% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_transformation.R
\name{linear_transformation}
\alias{linear_transformation}
\title{Shift peaks to eliminate systematic inaccuracies of peak detection by GC.}
\usage{
linear_transformation(gc_peak_list, reference, max_linear_shift = 0.05,
  step_size = 0.01, rt_col_name, Logbook)
}
\arguments{
\item{gc_peak_list}{List of data.frames. Each data.frame contains GC-data
(e.g. retention time, peak area, peak height) of one sample. Variables are
stored in columns. Rows represent distinct peaks. Retention time is a
required variable.}

\item{reference}{character string with the name of a sample included in \code{gc_peak_list} used as a reference to align to.}

\item{max_linear_shift}{This value defines the maximum time that one chromatogram is expected to be deviating in retention times
from another chromatogram. To correct for these systematic shifts, the algorithm potentially adds the same
retention time to all peaks within a chromatogram to maximise the number of shared peaks with
the reference. We recommend to start with the default of 0.02 (minutes) and increase if necessary.}

\item{step_size}{integer, indicating the step size in which linear shifts are evaluated between \strong{max_linear_shift} and \strong{-max_linear_shift}.}

\item{rt_col_name}{Character string - the name of the column containing the retention times.The variable needs to
be numeric and the decimal separator needs to be a point.}
}
\value{
\item{chroma_aligned}{Transformed data}
\item{Logbook}{Logbook, record of the applied shifts}
List of data.frames containing chromatograms with applied linear shifts
}
\description{
\strong{linear_transformation()} shifts all peaks within chromatograms to maximise the number
of shared peaks with a reference chromatogram. Optimally, the reference contains known peaks which
also occur in the samples. If a sample is taken as a reference, samples with high concentrations
and clear peaks will lead to a better result.
}
\author{
Martin Stoffel (martin.adam.stoffel@gmail.com) &
        Meinolf Ottensmann (meinolf.ottensmann@web.de)
}
\keyword{internal}

