##
## Conversion from/to decimal-binary
##

decimal2binary <- function(x, length)
{
  x <- as.integer(x)
  b <- if(missing(length)) NULL else rep(0, length)
  i <- 0
  while(x >= 1)
       { i <- i + 1
         b[i] <- x %% 2
         x <- x %/% 2 }
  return(rev(b))
}

binary2decimal <- function(x)
{
  sum(x * 2^(rev(seq(along=x)) - 1))  
}

## old versions
# decimal2binary <- function(x)
# {
#   x <- as.integer(x)
#   b <- NULL
#   while(x > 1)
#        { b <- c(x %% 2, b)
#          x <- x %/% 2 }
#   b <- c(x %% 2, b)
#   return(b)
# }
#
# binary2decimal <- function(x)
# {
#   l <- length(x)
#   i <- seq(l-1, 0)
#   d <- sum(x*2^i)
#   return(d)
# }



##
## Gray coding for binary genetic algorithm
## Based on algorithm on Eiben Smith (2003) Introduction to Evolutionary Computing
##

binary2gray <- function(x)
{
  x <- as.logical(x)
  n <- length(x)
  g <- vector(mode = "logical", length = n)
  g[1] <- x[1]
  for(i in 2:n)
     { g[i] <- xor(x[i-1], x[i]) }
  g <- as.numeric(g)
  return(g)
}

gray2binary <- function(x)
{
  x <- as.logical(x)
  n <- length(x)
  b <- vector(mode = "logical", length = n)
  b[1] <- value <- x[1]
  for(i in 2:n)
     { if(x[i]) value <- !value
       b[i] <- value }
  b <- as.numeric(b)
  return(b)
}

##
## Other functions
##

jet.colors <- function(n)
{
# Creates a palette of n colors beginning with dark blue, ranging through
# shades of blue, cyan, green, yellow and red, and ending with dark red. 
# This is inspired by the colormap 'jet' available in Matlab.
  palette <- colorRampPalette(c("#00007F", "blue", "#007FFF", 
                                "cyan", "#7FFF7F", "yellow", 
                                "#FF7F00", "red", "#7F0000"))
  palette(n)
}

persp3D <- function(x, y, z, theta = 30, phi = 20, d = 5, expand = 2/3, xlim = range(x, finite = TRUE), ylim = range(y, finite = TRUE), zlim = range(z, finite = TRUE), levels = pretty(zlim, nlevels), nlevels = 20, color.palette = jet.colors, border = NA, ticktype = "detailed", xlab = NULL, ylab = NULL, zlab = NULL, ...)
{
#----------------------------------------------------------------------------#  
# 3D plot, i.e. perspective plot, with different levels in different colors
#
# Example
# y <- x <- seq(-10, 10, length=60)
# f <- function(x,y) { r <- sqrt(x^2+y^2); 10 * sin(r)/r }
# z <- outer(x, y, f)
# persp3D(x, y, z, theta = 30, phi = 30, expand = 0.5)
# persp3D(x, y, z, color.palette = heat.colors, phi = 30, theta = 225, box = TRUE, border = NA, shade = .4)
# persp3D(x, y, z, color.palette = terrain.colors, phi = 30, theta = 225, box = FALSE, border = NA, shade = .4)
#
# x1 = seq(-3,3,length=50)
# x2 = seq(-3,3,length=50)
# y = function(x1, x2) sin(x1)+cos(x2)
# persp3D(x1, x2, outer(x1,x2,y), zlab="y", theta = 150, phi = 20, expand = 0.6)
#
#----------------------------------------------------------------------------#

  if(is.null(xlab)) 
     xlab <- if(!missing(x)) 
                deparse(substitute(x))
             else "X"
  if(is.null(ylab)) 
     ylab <- if(!missing(y)) 
                deparse(substitute(y))
             else "Y"
   if(is.null(zlab)) 
      zlab <- if(!missing(z)) 
                 deparse(substitute(z))
              else "Z"
  if(missing(z))
    { if(!missing(x)) 
        { if(is.list(x)) 
            { z <- x$z
              y <- x$y
              x <- x$x }
          else 
            { z <- x
              x <- seq.int(0, 1, length.out = nrow(z)) }
         }
      else stop("no 'z' matrix specified")
    }
  else if(is.list(x))
         { y <- x$y
           x <- x$x }
  if(any(diff(x) <= 0) || any(diff(y) <= 0)) 
     stop("increasing 'x' and 'y' values expected")

  # getting the value of the midpoint
  zz <- (z[-1,-1] + z[-1,-ncol(z)] + z[-nrow(z),-1] + z[-nrow(z),-ncol(z)])/4
  # set colors for levels
  cols <- color.palette(length(levels)-1)
  zzz <- cut(zz, breaks = levels, labels = cols)
  # plot
  out <- persp(x, y, z, theta = theta, phi = phi, d = d, expand = expand,
               col = as.character(zzz),
               xlim = xlim, ylim = ylim, zlim = zlim,
               border = border, ticktype = ticktype, 
               xlab = xlab, ylab = ylab, zlab = zlab, ...)
  # add breaks and colors for a legend
  out <- list(persp = out, levels = levels, colors = cols)
  invisible(out)
}
