% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyInferenceSystem.R
\name{addvar}
\alias{addvar}
\title{Insert a variable}
\usage{
addvar(fis, varType, varName, varBounds, method = NULL, params = NULL)
}
\arguments{
\item{fis}{A fis must be provided.}

\item{varType}{Should be either 'input' or 'output' which represents the type of variable to be created and added.}

\item{varName}{A string representing the name of the variable.}

\item{varBounds}{Also known as the 'range', this should be a vector giving a range for the variable, such as 1:10.}

\item{method}{fuzzification or defuzzification method}

\item{params}{the required parameters for the corresponding fuzzification or defuzzification method.
For example, the required parameters for \code{\link{gbell.fuzzification}} are c(a,b)}
}
\value{
A fis with the new variable added.
}
\description{
Adds an input or output variable to a fis object.
}
\examples{
fis <- newfis('tipper')
fis <- addvar(fis, 'input', 'service', c(0, 10))
}
