% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANFIS.R
\name{anfis.optimise}
\alias{anfis.optimise}
\title{ANFIS optimiser}
\usage{
anfis.optimise(anfis, data.trn, data.chk = NULL, epoch.total = 100,
  stepsize = 0.1, rate.inc = 1.1, rate.dec = 0.9, method = c("gradient",
  "lse"), err.log = F, online = 0, lambda = 1, opt.by = "err.opt")
}
\arguments{
\item{anfis}{The given ANFIS model}

\item{data.trn}{The input and output data pairs as training data}

\item{data.chk}{The input and output data pairs as checking (validation) data}

\item{epoch.total}{The total training epochs.}

\item{stepsize}{The initial stepsize}

\item{rate.inc}{increasing rate of the stepsize}

\item{rate.dec}{decrasing rate of the stepsize}

\item{method}{The learning algorithms for Layer 1 and Layer 4 respectively. default method=c("gradient", "lse")}

\item{err.log}{T or F, the flag indicate whether to save the error log.}

\item{online}{0 -- batch; 1 -- online; 2 -- semi-online}

\item{lambda}{The forgetting rate for the LSE algorithm}

\item{opt.by}{To optimise the ANFIS model by: err.opt -- optimisation error; err.trn -- training error; err.chk -- checking (validation) error.}
}
\value{
The optimised ANFIS model.
}
\description{
To optimise the performance of a given ANFIS model by learning the parameters in L1 and L4.
}
\examples{
fis <- anfis.tipper()
anfis <- anfis.builder(fis)
data.num <- 5
input.num <- length(fis$input)
input.stack <- matrix(rnorm(data.num*input.num), ncol=input.num)
y <- matrix(rnorm(data.num))
data.trn <- cbind(input.stack, y)
anfis.eval(anfis, input.stack)
anfis.final <- anfis.optimise(anfis, data.trn, epoch.total=500,
                                 stepsize=0.01, rate.inc=1.1, rate.dec=0.9)
}
\author{
Chao Chen
}
\references{
An extended ANFIS architecture and its learning properties for type-1 and interval type-2 models \url{http://eprints.nottingham.ac.uk/33465/}
}

