\docType{class}
\name{TrapezoidalFuzzyNumber-class}
\alias{TrapezoidalFuzzyNumber-class}
\title{S4 class Representing a Trapezoidal Fuzzy Number}
\description{
  Trapezoidal Fuzzy Numbers have linear side functions and
  alpha-cut bounds.
}
\details{
  Trapezoidal fuzzy numbers are among the simplest FNs.
  Despite their simplicity, however, they include
  triangular FNs, ``crisp'' real intervals, and ``crisp''
  reals. Please note that currently no separate classes for
  these particular TFNs types are implemented in the
  package.
}
\section{Slots}{
  \describe{ \item{\code{a1}, \code{a2}, \code{a3},
  \code{a4}, \code{lower}, \code{upper}, \code{left},
  \code{right}:}{ Inherited from the
  \code{\linkS4class{FuzzyNumber}} class.} }
}

\section{Extends}{
  Class \code{\linkS4class{FuzzyNumber}}, directly.
}
\examples{
showClass("TrapezoidalFuzzyNumber")
showMethods(classes="TrapezoidalFuzzyNumber")
}
\seealso{
  \code{\link{TrapezoidalFuzzyNumber}} for a convenient
  constructor, \code{\link{as.TrapezoidalFuzzyNumber}} for
  conversion of objects to this class, and
  \code{\link{trapezoidalApproximation}} for approximation
  routines.

  Other TrapezoidalFuzzyNumber-method:
  \code{\link{alphaInterval}}, \code{\link{Arithmetic}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{expectedInterval}}, \code{\link{plot}},
  \code{\link{TrapezoidalFuzzyNumber}},
  \code{\link{TriangularFuzzyNumber}}
}

