% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntroducingNA.R
\name{IntroducingNA}
\alias{IntroducingNA}
\title{Introducing NAs to the specified matrix.}
\usage{
IntroducingNA(dataMatrix, percentage = 0.05, ...)
}
\arguments{
\item{dataMatrix}{Name of the input matrix (or list, or data frame).}

\item{percentage}{Desired percentage of missing values (NAs) in each row.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is given as a matrix.
}
\description{
`IntroducingNA` introduces missing values (NAs) to the specified data matrix.
}
\details{
The procedure changes randomly some values in the specified matrix to "missing values" (denoted by NA).
Number of these missing values in each row is given by the parameter \code{percentage}.
If the input is a list of fuzzy numbers or data frame, then it is automatically converted to a matrix.
}
\examples{



# prepare matrix with 3 columns and 3 rows

matrix1 <- matrix(c(1,3,5,2,5,7,1,4,5),ncol=3,byrow = TRUE)

# add 1 NA in each row

set.seed(12345)

IntroducingNA(matrix1,percentage = 0.33)


}
