% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzifyMatrix.R
\name{FuzzifyMatrix}
\alias{FuzzifyMatrix}
\title{Fuzzyfing the crisp values.}
\usage{
FuzzifyMatrix(
  crispMatrix,
  coreFactor = 0.2,
  supportFactor = 0.2,
  trapezoidal = TRUE,
  varNames = colnames(crispMatrix),
  ...
)
}
\arguments{
\item{crispMatrix}{Name of the input matrix (or data frame) with real-valued variables to fuzzify.}

\item{coreFactor}{Value used as the multiplier for the right end of the interval of the uniform distribution applied to
randomly generated increments of the core.}

\item{supportFactor}{Value used as the multiplier for the right end of the interval of the uniform distribution applied to
randomly generated increments of the support.}

\item{trapezoidal}{Logical value that indicates if trapezoidal (or triangular, otherwise) fuzzy numbers should be generated.}

\item{varNames}{Names of the input variables.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is given as a matrix with three (in the case of triangular fuzzy numbers) or four (for trapezoidal
fuzzy numbers) columns for each input variable.
}
\description{
`FuzzifyMatrix` converts real-valued variables into fuzzy numbers.
}
\details{
The procedure generates trapezoidal fuzzy numbers (when the default \code{trapezoidal=TRUE} is set) or triangular
ones (for \code{trapezoidal=FALSE}) based on the real-valued data from the given matrix or the data frame.
To do this, for each variable the standard deviation is calculated.
Then, the left and right increments of the core (in the case of trapezoidal fuzzy numbers) are
randomly generated using the original value plus/minus two random values from
the uniform distribution on the interval [0,\code{coreFactor}*(standard deviation)].
In the case of triangular fuzzy numbers, the cores are equal to the original real values.
In the same manner, the left and right increments of the support are randomly generated with
two random values from the uniform distribution on the interval [0,\code{supportFactor}*(standard deviation)].
}
\examples{

# set seed for the random generator

set.seed(12345)

# let's look at the beginning of the iris dataset (four numeric variables)

head(iris[,1:4])

# and fuzzify these variables

fuzzyOutput <- FuzzifyMatrix(iris[,1:4])

head(fuzzyOutput)


}
