% Generated by roxygen2 (4.0.1): do not edit by hand
\name{HT}
\alias{HT}
\title{Horvitz - Thompson estimator}
\usage{
HT(y, pik)
}
\arguments{
\item{y}{A numeric vector of size n containing information about variable of interest}

\item{pik}{A numeric vector of size n containing first order inclusion probabilities for units included in \code{y}}
}
\value{
A numeric value representing Horvitz - Thompson estimator for population total for considered values
}
\description{
Computes the Horvitz - Thompson estimator
}
\details{
Horvitz - Thompson estimator of population total is given by
 \deqn{\hat{Y}_{HT} = \sum_{k \in s} \frac{y_k}{\pi_k}}
}
\examples{
##########   Example 1   ##########
U <- c(13, 18, 20, 14, 9)
#A simple random sample of size 2 without replacement is drawn from population
s <- sample(U, 2)
ps <- c(0.4, 0.4)
HT(s, ps)

##########   Example 2   ##########
data(HouseholdsA)
attach(HouseholdsA)
#Let estimate population total for variable Feeding in frame A
HT(Feeding, ProbA)
}
\references{
Horvitz, D. G. and Thompson, D. J. (1952)
 \emph{A generalization of sampling without replacement from a finite universe.}
 Journal of the American Statistical Association, 47, 663 - 685
}
\seealso{
\code{\link{VarHT}}
}

