% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_overview.R
\name{survey_overview}
\alias{survey_overview}
\title{Generate an Overview of the Surveys of an fe_stand Object}
\usage{
survey_overview(x, tree_filter = TRUE)
}
\arguments{
\item{x}{An object of class \code{\link{fe_stand}}}

\item{tree_filter}{A \code{data-masking} expression that applies to the
data.frame \code{x$trees}. It must return a logical value, and is defined
in terms of the variables in \code{x$trees}. In this function, it is used
internally in order to define the cohort of trees which is to be evaluated
by this function (within a call to \code{dplyr::filter()}). For this
function, \code{tree_filter} should almost \emph{never} be something else
than \code{TRUE} (default)}
}
\value{
A data frame (tibble) that gives an overview of the surveys
represented in the input object \code{x}. It is basically an evaluation of
the data frame \code{x$trees}. It provides information about how many trees
were present in each survey, how many dbh and heights were measured, and
if the dbh and height measurements cover all trees, For dbh this must be
always true, because this is a requirement for a valid
\code{\link{fe_stand}} object. In addition, we are informed whether a
species that has been documented in the object is represented in a specific
survey or not. As a basis for advanced evaluations, species occurences are
numbered in the columen \code{n_species_occurrence} (see Details). In case
an object of class \code{fe_ccircle_spatial_notrees} (which is a special
child of \code{\link{fe_stand}}) is provided as input \code{x}, the
function returns an empty data frame.
}
\description{
The tree data frame of an \code{\link{fe_stand}} object is evaluated in order
to get survey and species specific meta information about these data.
}
\details{
This function provides meta information that is useful for evaluations that
can be complex on the detail level, e.g. increment calculations from
subsequent surveys. In such contexts, the column \code{n_species_occurence}
of the output data frame can be of special interest. If a species is present
for a number of consecutive surveys, all these surveys get the same integer
number in this column. If the same species vanishes, but occurs again later,
the next block of surveys gets the subsequent number, and so on. So, all
consecutive blocks of a species' occurrence are numbered as 1, 2, 3, etc.
At surveys where the species is not present \code{n_species_occurrence} has
the value 1.
}
\examples{
  # Example data: Mixed mountain forest plot with several surveys
  mm_forest_1_fe_stand_spatial |> survey_overview()

}
