% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assmann_layers.R
\name{assmann_layers}
\alias{assmann_layers}
\title{Attribute Tree Heights to Layers After Ernst Assmann}
\usage{
assmann_layers(heights, reference_height = NULL)
}
\arguments{
\item{heights}{Vector of tree heights}

\item{reference_height}{Reference height for the 100\% level. If \code{NULL}
(default), the maximum of \code{heights} will be used as reference height.}
}
\value{
An ordered factor of T, M, B values, corresponding to
\code{heights} in the order as \code{heights} was provided.
}
\description{
Tree heights are attributed to three layers as proposed by
\insertCite{assmann_1961;textual}{ForestElementsR}. The layers are called
Top, T, Middle, M, and Bottom, B, and correspond to >80\%, >50\%, and >0\% of
a reference height (usually the height of the highest tree in the stand of
interest).
}
\examples{
  # Monospecific stand
  trees <- norway_spruce_1_fe_stand$trees
  assmann_layers(trees$height_m)

  # Selection forest
  trees <- selection_forest_1_fe_stand$trees
  assmann_layers(trees$height_m)

}
\references{
\insertAllCited{}
}
\seealso{
Other structure and diversity: 
\code{\link{shannon_index}()},
\code{\link{species_profile}()}
}
\concept{structure and diversity}
