% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_index.R
\name{score_index}
\alias{score_index}
\title{Measuring forecasting accuracy}
\usage{
score_index(recf, base, test, m, nb, type = "mse", compact = TRUE)
}
\arguments{
\item{recf}{list of q (forecast origins) reconciled forecasts' matrices (\code{[n x h(k* + m)]} in the
cross-temporal, \code{[h x n]} in cross-sectional and vectors of length \code{[h(k* + m)]} in temporal framework).}

\item{base}{list of q (forecast origins) base forecasts' matrices (\code{[n x h(k* + m)]} in the
cross-temporal, \code{[n x h]} in cross-sectional and \code{[h(k* + m) x 1]} in temporal framework).}

\item{test}{list of q (forecast origins) test observations' matrices (\code{[n x h(k* + m)]} in the
cross-temporal, \code{[n x h]} in cross-sectional and \code{[h(k* + m) x 1]} in temporal framework).}

\item{m}{highest frequency of the forecasted time series.}

\item{nb}{number of bottom time series in the cross-sectional framework.}

\item{type}{type of accuracy measure ("\code{mse}" Mean Square Error, "\code{rmse}" Root Mean Square Error
or "\code{mae}" Mean Absolute Error)}

\item{compact}{if TRUE return only the summary matrix.}
}
\value{
It returns a summary table called \code{Avg_mat} (if \code{compact} option is \code{TRUE},
\emph{default}), otherwise it returns a list of four tables (more in
\href{https://danigiro.github.io/FoReco/articles/accuracy_indices.html}{Average relative accuracy indices}).
}
\description{
Function to calculate the accuracy indices of the reconciled point
forecasts of a cross-temporal (not only, see examples) system (more in
\href{https://danigiro.github.io/FoReco/articles/accuracy_indices.html}{Average relative accuracy indices}).
}
\examples{
\donttest{
data(FoReco_data)

# Cross-temporal framework
oct_recf <- octrec(FoReco_data$base, m = 12, C = FoReco_data$C,
                   comb = "bdshr", res = FoReco_data$res)$recf
oct_score <- score_index(recf = oct_recf,
                         base = FoReco_data$base,
                         test = FoReco_data$test, m = 12, nb = 5)

# Cross-sectional framework
# monthly base forecasts
id <- which(simplify2array(strsplit(colnames(FoReco_data$base), split = "_"))[1, ] == "k1")
mbase <- t(FoReco_data$base[, id])
# monthly test set
mtest <- t(FoReco_data$test[, id])
# monthly residuals
id <- which(simplify2array(strsplit(colnames(FoReco_data$res), split = "_"))[1, ] == "k1")
mres <- t(FoReco_data$res[, id])
# monthly reconciled forecasts
mrecf <- htsrec(mbase, C = FoReco_data$C, comb = "shr", res = mres)$recf
# score
hts_score <- score_index(recf = mrecf, base = mbase, test = mtest, nb = 5)

# Temporal framework
data(FoReco_data)
# top ts base forecasts ([lowest_freq' ...  highest_freq']')
topbase <- FoReco_data$base[1, ]
# top ts residuals ([lowest_freq' ...  highest_freq']')
topres <- FoReco_data$res[1, ]
# top ts test ([lowest_freq' ...  highest_freq']')
toptest <- FoReco_data$test[1, ]
# top ts recf ([lowest_freq' ...  highest_freq']')
toprecf <- thfrec(topbase, m = 12, comb = "acov", res = topres)$recf
# score
thf_score <- score_index(recf = toprecf, base = topbase, test = toptest, m = 12)
}

}
\references{
Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.
}
\keyword{utilities}
