% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_modified_migration.R
\name{generate_modified_migration}
\alias{generate_modified_migration}
\title{Return a modified migration according generative parameters.}
\usage{
generate_modified_migration(
  migr,
  death_probability_mode = "no",
  death_probability_domain = c(0.01, 0.05),
  sojourn_mode = "no",
  sojourn_domain = c(1, 10),
  flight_duration_mode = "no",
  flight_duration_domain = c(1, 5),
  transition_mode = "no",
  observation_mode = "no",
  observation_hide = 0.1
)
}
\arguments{
\item{migr}{A migration structure.}

\item{death_probability_mode}{Either "no", "mean" or "unif" 
(or a vector of such values of length the number of sites). If "no", 
death probability is not modified. If "mean" death probability 
are set to the mean value of the death_probability_domain. If "unif", 
the death probabilities are drawn uniformly into the range of the 
death_probability_domain. Default is "no".}

\item{death_probability_domain}{Min and max of death probabilities. 
Used only if death_probability_mode is not "no". Default is c(0.01,0.05)}

\item{sojourn_mode}{Either "no", "mean" or "unif" (or a vector of such values 
of length the number of sites). If "no", sojourn mean time is not modfied. 
If "mean" sojourns mean time is set to the mean value of the sojourn_domain. 
If "unif", the sojourn mean time is drawn uniformly into the range of 
the sojourn_domain. Default is "no".}

\item{sojourn_domain}{Min and max of sojourn mean time. 
If vector of 2 values min and max then all domains are [min, max] interval,
else contains the list of interval for each site.
Used only if sojourn_type is not "no". Default is c(1,10)}

\item{flight_duration_mode, }{Either "no", "mean" or "unif". If "no", flight 
durations are not modified. If "mean" flight durations are set to the 
closest integer of the mean value of the flight_duration_domain. 
If "unif", the flight durations are drawn uniformly into the range of 
the flight_duration_domain Default is "no".}

\item{flight_duration_domain, }{Min and max integers of flight durations. 
Used only if sojourn_type is not "no". Default is c(1,5)}

\item{transition_mode}{Either "no", "equi" or "unif". If "no", 
the transition are not modified. If "equi" transition 
are equiprobable taking into account the link_knowledge. If "unif" 
transitions are drawn uniformly. Default is "no".}

\item{observation_mode}{Either "no", "simulation" or "hide". If "no",
the observations are not modified. If "simulation", the observations as well 
as the horizon are computed from a simulation of the migration. The horizon 
is set to the time at which all birds are either dead or at the arrival 
site. If "hide", observations are replaced with NA with probability 
observation_hide. Default is "no".}

\item{observation_hide}{probability of hidding a single observation. Used 
only if observation_mode is "hide". Default is 0.1.}
}
\value{
A migration modified according the specifications
}
\description{
Return a modified migration according generative parameters.
}
\examples{
migr <- generate_random_migration()
mod_migr <- generate_modified_migration(migr, transition_mode = "unif")
}
