% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaFluMoDL.R
\name{metaFluMoDL}
\alias{metaFluMoDL}
\title{Multivariate meta-analysis for FluMoDL objects}
\usage{
metaFluMoDL(summaries, par = c("H1", "H3", "B", "RSV"))
}
\arguments{
\item{summaries}{A \emph{list} of objects of class \code{\link{summary.FluMoDL}}
(at least two), representing the first-stage analyses. If the list is named, the
names are kept in the output object and can be retrieved with \code{names()}, see below.}

\item{par}{For which model terms (sets of coefficients) to run the meta-analysis?
Defaults to \code{c("H1","H3","B","RSV")}, which
indicates all three influenza proxies and RSV (for those summaries that have included
an RSV term). It is unlikely that you'll want to alter this default.}
}
\value{
Returns an object of class 'metaFluMoDL'. This is a list of objects of class
  \code{\link[mvmeta]{mvmeta}}, representing the results of the multivariate
  random-effects meta-analysis for the sets of coefficients corresponding to each
  term in argument \code{par}; they can be accessed directly using the \code{$}
  operator as \code{$proxyH1}, \code{$proxyH3} and \code{$proxyB} (and also
  \code{$proxyRSV} if there were RSV terms in at least two elements of
  \code{summaries} and \code{par} included "RSV" -- in which case,
  \code{\link[=hasRSV]{hasRSV()}} returns \code{TRUE} for objects of class 'metaFluMoDL').

  \emph{However}, some methods have been redefined for class 'metaFluMoDL', and do not
  work the same as in simple lists. In particular: \code{\link[=length]{length()}}
  returns the number of summaries (number of "studies") meta-analyzed and
  \code{\link[=names]{names()}} returns the names of these summaries (if the list
  in \code{summaries} argument was named).

  In addition, the \code{[[} and \code{[} operators have been redefined for class
  'metaFluMoDL', and now return the Best Linear Unbiased Predictor (BLUP)
  estimates for the selected summaries ("studies"), as objects of class
  \code{\link{summary.FluMoDL}}; selection can be made the usual way,
  with a logical or numeric index vector, or with the summary names
  (as provided by \code{names}). \code{[} returns a \emph{list} of
  \code{\link{summary.FluMoDL}} objects, whereas \code{[[} returns a single object.
  The returned objects contain the string "blup" in their \code{$type} element,
  to distinguish them from \code{\link[=summary.FluMoDL]{first-stage model summaries}}
  or \code{\link{pooled}}
  result summaries. In their \code{$description} element, they contain the
  name of the respective summary ("study") if a named list had been provided
  in the \code{summaries} argument of \code{metaFluMoDL()}. And finally, they contain
  no \code{$pred} element, as they are not associated with a particular dataset and
  cross-basis matrices (which is a prerequisite to create
  \code{\link[dlnm]{crosspred}} objects).

  The pooled coefficients (for all three or four incidence proxies) can be obtained
  with function \code{\link[=pooled]{pooled()}}, which also returns an object of class
  \code{\link{summary.FluMoDL}} that you can further use.
}
\description{
This function runs multivariate meta-analysis (using package \code{\link{mvmeta}})
on the first-stage coefficients of influenza (and possibly RSV) incidence proxies
for multiple 'FluMoDL' object summaries.
}
\references{
\itemize{
 \item Gasparrini A, Armstrong B, Kenward MG. Multivariate meta-analysis for non-linear
  and other multi-parameter associations.
  \href{https://onlinelibrary.wiley.com/doi/full/10.1002/sim.5471}{Stat Med} 2012;31(29):3821–39.
}
}
\seealso{
\code{\link{summary.FluMoDL}}, \code{\link{pooled}}
}
