% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.all.R
\name{metrics.all}
\alias{metrics.all}
\title{Streamflow metrics}
\usage{
metrics.all(TS, Qmax = 0.95, Dur = 5, Qdr = 0.2, WinSize = 30,
  Season = c(4:9), NAthresh = 0.5, language = "English")
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{Qmax}{Numeric value for peaks over threshold quantile.
Default is 0.95.}

\item{Dur}{Numeric value for minimum number of days between flood peaks.
Default is 5.}

\item{Qdr}{Numeric value for drought quantile.  Default is 0.2, i.e. the 80th percentile
of the flow duration curve.}

\item{WinSize}{Numeric value for moving window size (in days) for the moving
window quantile drought threshold. See \code{\link{mqt}}. Default is 30.}

\item{Season}{Numeric vector of months during which droughts start. Default 
is c(4:9) for non-frost season droughts.}

\item{NAthresh}{Numeric value indicating the threshold for missing data points
in any one year.  Default is 0.5, indicating that years with more than 50 percent missing data
will be omitted from the metric calculations. This value should always be set to 
greater than 0.1, as years with fewer observations than approximately 1 month will
cause errors.}

\item{language}{Character string indicating the language to be used for naming
the different plot metrics. These names are used in \code{\link{screen.summary}}
to label individual plots. Options are "English" or "French".  Default is "English".}
}
\value{
Returns a list with the following elements:

  metricTS: a list containing a vector of each metric calculated. Each
  vector has a times attribute providing either the year for metrics with 
  one observation per year or a date for metrics that may have more than one 
  observation per year (e.g., Peaks Over Threshold).  This 
  list has the following elements:
  \itemize{
    \item Annual Maximum Series - calculated with \code{\link{pk.max}}
    \item Day of Annual Maximum - calculated with \code{\link{pk.max.doy}}
    \item Peaks Over Threshold (Qmax) - calculated with \code{\link{pks}}
    \item Inter-Event Duration - calculated with \code{\link{pks.dur}}
    \item Q80 - calculated with \code{\link{Qn}}
    \item Q90 - calculated with \code{\link{Qn}}
    \item Day of Year 25 percent Annual Volume - calculated with \code{\link{pk.cov}}
    \item Center of Volume - calculated with \code{\link{pk.cov}}
    \item Day of Year 75 percent Annual Volume - calculated with \code{\link{pk.cov}}
    \item Duration between 25 percent and 75 percent Annual Volume - calculated with \code{\link{cov}}
    \item Q10 - calculated with \code{\link{Qn}}
    \item Q25 - calculated with \code{\link{Qn}}
    \item Drought Start - calculated with \code{\link{dr.seas}}
    \item Drought Center - calculated with \code{\link{dr.seas}}
    \item Drought End - calculated with \code{\link{dr.seas}}
    \item Drought Duration - calculated with \code{\link{dr.seas}}
    \item Drought Severity - calculated with \code{\link{dr.seas}}
    \item Annual Minimum Flow - calculated with \code{\link{MAMn}}
    \item Mean Annual Minimum 7-day Flow - calculated with \code{\link{MAMn}}
    \item Mean Annual Minimum 10-day Flow - calculated with \code{\link{MAMn}}
    \item Mean Daily Discharge - calculated with \code{\link{bf.stats}}
    \item Annual Baseflow Volume - calculated with \code{\link{bf.stats}}
    \item Annual Mean Baseflow - calculated with \code{\link{bf.stats}}
    \item Annual Maximum Baseflow - calculated with \code{\link{bf.stats}}
    \item Annual Minimum Baseflow - calculated with \code{\link{bf.stats}}
    \item Mean Annual Baseflow Index - calculated with \code{\link{bf.stats}}
    \item Day of Year 25  percent Baseflow Volume - calculated with \code{\link{pk.bf.stats}}
    \item Center of Volume Baseflow - calculated with \code{\link{pk.bf.stats}}
    \item Day of Year 75  percent Baseflow Volume - calculated with \code{\link{pk.bf.stats}}
    \item Duration between 25  percent and 75  percent Baseflow Volume - calculated with \code{\link{pk.bf.stats}}
  }
  
  tcpRes: this list contains the results of the trend and changepoint analysis
  for each of the metrics in the metricTS list described above. Each list 
  element is a list containing the following elements:
  \itemize{
    \item MetricID - integer used to identify the metric
    \item MetricName - Name of the metric.
    \item Slope - numeric vector containing the intercept and slope of the 
      prewhitened linear trend calculated using the Yue Pilon method. See
      \code{\link[zyp]{zyp.trend.vector}}
    \item ci1 - upper bound of the trend's 95 percent confidence interval
    \item ci2 - lower bound of the trend's 95 percent conficence interval
    \item pval - Kendall's P-value computed for the detrended time series
    \item cpts - Most probable location of a changepoint, if one is detected. 
    \item means - Mean before and after the changepoint
    \item NumObs - The number of data points for the metric
  }
  
  inData: A data.frame of the original input daily streamflow time series.
  
  OmitYrs: A data.frame containing the years and the number of observations for
  any years omitted from the analysis due to insufficient data.  If no years were
  omitted, NA is returned.
}
\description{
Calculates 30 different flow metrics, 10 each for high flows, low flows, and baseflow.
}
\details{
This function calculates streamflow metrics and calculates the 
  prewhitened trend using \code{\link[zyp]{zyp.trend.vector}} and looks
  for changpoints in mean and variance using \code{\link[changepoint]{cpt.meanvar}}
  This function is intended for use as a data quality screening tool aimed 
  at identifying streamflow records with anthropogenic impacts and should not be used
  to complete a temporal trend analysis, as the calculated metrics may not be 
  appropriate for all catchments. See the functions linked in the following section
  for details on how each metric is calculated.
}
\examples{
# load subset of daily streamflow time series for the Caniapiscau River
data(cania.sub.ts)

# further subset to meet maximum example run-time requirements
cania.sub.ts <- subset(cania.sub.ts, cania.sub.ts$hyear \%in\% c(1973:1987))

# calculate low flow, high flow, and baseflow metrics
res <- metrics.all(cania.sub.ts)
}
\author{
Jennifer Dierauer
}
\seealso{
See the documentation for individual functions linked in the 
  output description for a details on methods.
  
  See \code{\link{screen.metric}} to create individual plots for each metric.
}

