% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicted_residuals.R
\name{residuals.flexreg}
\alias{residuals.flexreg}
\title{Residuals Method for flexreg Objects}
\usage{
\method{residuals}{flexreg}(
  object,
  type = "raw",
  cluster = FALSE,
  estimate = "mean",
  q = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{`flexreg`}, usually the result of \code{\link{flexreg}} or \code{\link{flexreg_binom}} functions.}

\item{type}{a character indicating type of residuals (\code{"raw"} or \code{"standardized"}).}

\item{cluster}{logical. If the model is \code{"FB"} without augmentation or \code{"FBB"}, \code{cluster = TRUE} returns the cluster means. By default \code{cluster = FALSE}.}

\item{estimate}{a character indicating the type of estimate: \code{"mean"} (default), \code{"median"}, or \code{"quantile"}.}

\item{q}{if \code{estimate = "quantile"}, a numeric value of probability in (0, 1).}

\item{...}{additional arguments. Currently not used.}
}
\value{
The method returns an array with as many rows as the number of observations in the sample. If \code{cluster = FALSE}, the array has only one column containing either the raw or standardized residuals.
If \code{cluster = TRUE}, the array has four columns: the first column contains the raw or standardized residuals, the second and third columns contain the cluster residuals,
and the fourth column contains the classification labels (see Details).
}
\description{
Method that computes various types of residuals from objects of class \code{`flexreg`}. If the model type is  \code{FB} or \code{FBB} and \code{cluster = TRUE}, the method returns also residuals with respect to cluster means.
}
\details{
The \code{residuals} method  computes raw and standardized residuals from objects of class \code{`flexreg`}.
Raw residuals are defined as \eqn{r=y-\hat{\mu}} for bounded continuous  responses or as \eqn{r= y/n-\hat{\mu}} for bounded discrete responses.
Values \eqn{y} and \eqn{y/n} are  the observed
responses which are specified on the left-hand side of \code{formula} in the
\code{\link{flexreg}} and \code{\link{flexreg_binom}} functions, respectively.
Moreover,  \eqn{\hat{\mu}}  is the predicted value, the result of
the \code{\link{predict}} function with \code{type = "response"}.
Standardized residuals are defined as \eqn{\frac{r}{\sqrt{\widehat{Var}(y)}}} where
\eqn{\widehat{Var}(y)}
is the variance of the response evaluated at the posterior means
--by default, otherwise evaluated at the posterior quantiles of order \code{q}-- of the parameters.
If the model is \code{"FB"} or \code{"FBB"}, \code{type = "raw"}, and \code{cluster = TRUE}, the cluster raw residuals are computed as
the difference between the observed response/relative response  and the cluster means, i.e.,
\eqn{\hat{\lambda}_{1}} and \eqn{\hat{\lambda}_{2}}.
If the model is \code{"FB"} or \code{"FBB"}, \code{type = "standardized"} and \code{cluster = TRUE}, the cluster standardized residuals are computed as the
cluster raw residuals divided by the square root of the cluster variances.
Cluster residuals, either raw or standardized, can be used for classification purpose. Indeed, with \code{cluster = TRUE} the \code{residuals} method returns also a column named
\code{"label"} assigning values 1 or 2 to observations depending on whether they are classified in cluster 1 (if the corresponding cluster residual is smaller) or in cluster 2.
}
\examples{
\dontrun{
data("Reading")
FB <- flexreg(accuracy.adj ~ iq, data=Reading, type="FB")
residuals(FB, type="raw", cluster=TRUE)
}

}
\references{
{
Ascari, R., Migliorati, S. (2021). A new regression model for overdispersed binomial data accounting for outliers and an excess of zeros. Statistics in Medicine, \bold{40}(17), 3895--3914. doi:10.1002/sim.9005 \cr
\cr
Di Brisco, A. M., Migliorati, S. (2020). A new mixed-effects mixture model for constrained longitudinal data. Statistics in Medicine, \bold{39}(2), 129--145. doi:10.1002/sim.8406 \cr
\cr
Migliorati, S., Di Brisco, A. M., Ongaro, A. (2018). A New Regression Model for Bounded Responses. Bayesian Analysis, \bold{13}(3), 845--872. doi:10.1214/17-BA1079 \cr
}
}
