% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.plot.R
\name{convergence.plot}
\alias{convergence.plot}
\title{Convergence plots}
\usage{
convergence.plot(
  model,
  file = "convergence-output.pdf",
  plotfun = "all",
  pars = NULL,
  point_est = "median",
  prob = 0.5,
  prob_outer = 0.9,
  lags = 10,
  warmup = F,
  width = 7,
  height = 7
)
}
\arguments{
\item{model}{an object of class \code{`flexreg`}.}

\item{file}{a character string giving the name of the file (with extension .pdf).}

\item{plotfun}{an optional character vector of diagnostics plots. The default is to compute \code{all} plots, otherwise one can specify a selection of plots among \code{density}, \code{trace}, \code{intervals}, \code{rate}, \code{rhat}, and \code{acf}.}

\item{pars}{an optional character vector of parameter names. If \code{pars} is not specified, all parameters in the regression models are evaluated.}

\item{point_est}{an optional character to specify the point estimate to be shown between \code{median} (the default), \code{mean}, or \code{none}.}

\item{prob}{the probability mass to be included in the inner interval (\code{intervals} plot) or in the shaded region (for \code{density} plot). The default is 0.5.}

\item{prob_outer}{the probability mass to be included in the outer interval  of the \code{intervals} plot. The default is 0.9.}

\item{lags}{the number of lags to be shown in the \code{acf} plot. The default is 10.}

\item{warmup}{a logical scalar indicating whether to include the warmup draws or not (default).}

\item{width, height}{the width and height of the graphics region of each plot in inches. The default values are 7.}
}
\value{
A .pdf file with one plot per page.
}
\description{
The function produces a .pdf file containing some convergence plots for the Monte Carlo draws.
}
\details{
The plots can be further customized using the \code{ggplot2} package.
\itemize{
\item \code{density} returns a density plot for each parameter in \code{pars} computed from the posterior draws. See \code{bayesplot::mcmc_areas} for further details.
\item \code{trace} returns a trace plot for each parameter in \code{pars} computed from the posterior draws. See \code{bayesplot::mcmc_trace} for further details.
\item \code{intervals} returns a plot of uncertainty interval for each parameter in \code{pars} computed from the posterior draws. See \code{bayesplot::mcmc_intervals} for further details.
\item \code{rate} returns a plot for each parameter in \code{pars}  with the number of iterations on the x-axis and the Monte Carlo mean until iteration i-th on the y-axis.
\item \code{rhat} returns a plot with the Rhat values for each parameter in \code{pars}. See \code{bayesplot::mcmc_rhat} for further details.
\item \code{acf} returns the autocorrelation plots (one for each parameter in \code{pars}). See \code{bayesplot::mcmc_acf} for further details.

}
}
\references{
{
Brooks, SP., Gelman, A. (1998). General methods for monitoring convergence of iterative simulations. Journal of Computational and Graphical Statistics, \bold{7}, 434-455. \cr
\cr
Stan Development Team (2020). RStan: the R interface to Stan. R package version 2.19.3. https://mc-stan.org
}
}
