% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{curve.density}
\alias{curve.density}
\title{Draw density plots}
\usage{
curve.density(
  type = NULL,
  mu = NULL,
  phi = NULL,
  p = NULL,
  w = NULL,
  k = NULL,
  ...
)
}
\arguments{
\item{type}{a character specifying the distribution type to be plotted ( \code{"Beta"}, \code{"FB"}, or \code{"VIB"}).}

\item{mu}{the mean parameter of the distribution. It must lie in (0, 1).}

\item{phi}{the precision parameter of the distribution. It must be a positive real value.}

\item{p}{the mixing weight (to be specified if \code{type = "FB"} or \code{type = "VIB"}). It must lie in (0, 1).}

\item{w}{the normalized distance among clusters of the FB distribution (to be specified if \code{type = "FB"}). It must lie in (0, 1).}

\item{k}{the extent of the variance inflation (to be specified if \code{type = "VIB"}). It must lie in (0, 1).}

\item{...}{additional arguments of \code{stat_function()}.}
}
\description{
The function draws a curve corresponding to the probability density function of the specified distribution (beta, flexible beta, or variance-inflated beta).
}
\examples{
curve.density("Beta", mu=0.5, phi=20)
curve.density("FB", mu=0.5, phi=20, p=0.4, w=.8)
curve.density("VIB", mu=0.5, phi=20, p=0.9, k=.8, col=3)


}
\references{
{
Migliorati, S., Di Brisco, A. M., Ongaro, A. (2018) A New Regression Model for Bounded Responses. Bayesian Analysis, \bold{13}(3), 845--872. doi:10.1214/17-BA1079 \cr
\cr
Di Brisco, A. M., Migliorati, S., Ongaro, A. (2020) Robustness against outliers: A new variance inflated regression model for proportions. Statistical Modelling, \bold{20}(3), 274--309. doi:10.1177/1471082X18821213 \cr
\cr
 Ferrari, S.L.P., and Cribari-Neto, F. (2004). Beta Regression for Modeling Rates and Proportions. Journal of Applied Statistics, \bold{31}(7), 799--815. doi:10.1080/0266476042000214501
}
}
