% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flplot_Pfunction.R
\name{flplot_Pfunction}
\alias{flplot_Pfunction}
\title{Plot p function data extracted from NetCDF files downloaded by \code{FjordLight}.}
\usage{
flplot_Pfunction(irrLev, g, period, month, year, Main = NULL, add = add, ...)
}
\arguments{
\item{irrLev}{The chosen irradiance thresholds (x-axis).}

\item{g}{The percent of the fjord (y-axis) with a depth of 200 m or shallower receiving an
irradiance values (e.g. surface PAR) at or above the corresponding threshold (x-axis).}

\item{period}{The period being displayed. I.e. yearly or monthly.}

\item{month}{If monthly climatology data, which month(s) is being displayed.}

\item{year}{If yearly data, which year(s) is being displayed}

\item{Main}{The title of the plot. The default \code{NULL} will provide a title
'Pfunction yyy'. Where yyy is the annual or monthly period chosen.}

\item{add}{Boolean value of \code{TRUE} or \code{FALSE} telling the function to add this plot to the
current plot in the R Plots panel.}

\item{...}{Any other desired base R plotting functionality.}
}
\value{
A base R plot of the yearly or monthly p function data will be provided.
}
\description{
Internal function used by \code{\link{flget_Pfunction}} that plots data
contained within the NetCDF files downloaded via \code{\link{fl_DownloadFjord}}.
}
\author{
Bernard Gentili
}
\keyword{internal}
