% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFunctions.R
\name{PutTogetherIteratesWithoutJumps}
\alias{PutTogetherIteratesWithoutJumps}
\title{PutTogetherIteratesWithoutJumps
This function takes the previous inputs and outputs and assembles a matrix with both excluding jumps.}
\usage{
PutTogetherIteratesWithoutJumps(Inputs, Outputs, AgreementThreshold = 1e-10)
}
\arguments{
\item{Inputs}{This is an N x A matrix of previous inputs for which corresponding outputs are available. In this case N is the
dimensionality of the fixed point vector that is being sought (and each column is a matrix that is input to the "Function") and A is the
number of previous Inputs/Outputs that are being provided to the fixed point.}

\item{Outputs}{This is a matrix of "Function" values for each column of the "Inputs" matrix.}

\item{AgreementThreshold}{A parameter for determining when a column in Inputs and a column in Outputs match. They are deemed to match if
the sum of the absolute values of the difference in the columns is less than AgreementThreshold.}
}
\value{
A matrix of inputs and outputs excluding jumps.
}
\description{
PutTogetherIteratesWithoutJumps
This function takes the previous inputs and outputs and assembles a matrix with both excluding jumps.
}
\examples{
A = FixedPoint( function(x){c(0.5*sqrt(abs(x[1] + x[2])), 1.5*x[1] + 0.5*x[2])},
Inputs = c(0.3,900), MaxIter = 5, Method = "Simple")
A = FixedPoint( function(x){c(0.5*sqrt(abs(x[1] + x[2])), 1.5*x[1] + 0.5*x[2])},
Inputs = A$Inputs, Outputs = A$Outputs, MaxIter = 5, Method = "Aitken")
A = FixedPoint( function(x){c(0.5*sqrt(abs(x[1] + x[2])), 1.5*x[1] + 0.5*x[2])},
Inputs = A$Inputs, Outputs = A$Outputs, MaxIter = 5, Method = "Simple")
CombinedSequence = PutTogetherIteratesWithoutJumps(A$Inputs, A$Outputs)
}
