% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.rMR.R
\name{convert.rMR}
\alias{convert.rMR}
\title{Convert raw respirometry data (rMR)}
\usage{
convert.rMR(import.file, export.file,
            n.chamber = c(1,2,3,4,5,6,7,8),
            logger = c("AutoResp", "FishResp"),
            DO.units.in, DO.units.out, salinity = 0,
            bar.press = 101.325, bar.units.in = "kpa")
}
\arguments{
\item{import.file}{the name of a file with raw respirometry data which should be imported to convert DO units}

\item{export.file}{the name of a file with results of the DO unit conversion}

\item{n.chamber}{integer: the number of chambers used in an experiment (including empty ones)}

\item{logger}{string: the name of a logger software used for intermittent-flow respirometry}

\item{DO.units.in}{string: dissolved oxygen unit in an imported file (more information can be found in documentation of the function \code{\link{DO.unit.convert}}, R package \pkg{rMR})}

\item{DO.units.out}{string: dissolved oxygen unit in an exported file (more information can be found in documentation of the function \code{\link{DO.unit.convert}}, R package \pkg{rMR})}

\item{salinity}{string: salinity is measured in ppm (more information can be found in documentation of the function \code{\link{DO.unit.convert}}, R package \pkg{rMR})}

\item{bar.press}{string: ambient barometric pressure value (more information can be found in documentation of the function \code{\link{DO.unit.convert}}, R package \pkg{rMR})}

\item{bar.units.in}{string: barometric pressure unit (more information can be found in documentation of the function \code{\link{DO.unit.convert}}, R package \pkg{rMR})}
}
\value{
the function exports a data frame with converted DO units.
}
\description{
This function is a modification of the function \code{\link[rMR]{DO.unit.convert}} from the R package \pkg{rMR} allowing to convert raw respirometry data from one DO unit to another obtained in multichannel respirometry systems.
}
\examples{
# Import raw data for active metabolic rate
AMR.path = system.file("extdata/stickleback/AMR_raw.txt.xz", package = "FishResp")

convert.rMR(import.file = AMR.path,
            export.file = "converted_AMR_raw.txt",
            n.chamber = 2, logger = "AutoResp", salinity = 0,
            DO.units.in = "mg/L", DO.units.out = "PP",
            bar.press = 101.325, bar.units.in = "kpa")

}
