% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fi_score_region.R
\name{Fi_score_region}
\alias{Fi_score_region}
\title{Fi_score_region}
\usage{
Fi_score_region(pdb_df, i, j, include = FALSE)
}
\arguments{
\item{pdb_df}{Requires a PDB data frame generated by PDB_prepare}

\item{i}{start residue for a region}

\item{j}{end residue for a region}

\item{include}{inclusive or not calculation, default FALSE}
}
\value{
Fi-score value
}
\description{
Function calculates combined Fi-score for a selected region; NOTE: some PDB files have breakages in their amino acid sequences and those values cannot be assessed. Moreover, values can be calculated either inclusively or not; include is set to FALSE by default
}
\examples{
path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
# basic usage of Fiscore_secondary
pdb_df<-read.table(path_to_processed_PDB)
Fi_score_region(pdb_df,900,925)
}
