#' @title Fiscore_secondary
#'
#' @description Function plots a bar plot with  a secondary structure element visualisation based on PDB file data; NOTE: NA refers to unidentified region, e.g., a  likely disordered or unstructured region
#'
#' @param pdb_df Requires a PDB data frame generated by PDB_prepare
#' @return bar plot
#' @ImportFrom ggplot2 aes
#' @ImportFrom ggplot2 ggplot
#' @ImportFrom ggplot2 geom_bar
#' @ImportFrom ggplot2 scale_x_continuous
#' @ImportFrom ggplot2 scale_y_continuous
#' @ImportFrom ggplot2 xlab
#' @ImportFrom ggplot2 ylab
#' @ImportFrom ggplot2 ggtitle
#' @ImportFrom plotly  ggplotly
#' @export
#' @examples
#' path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
#' # basic usage of Fiscore_secondary
#' pdb_df<-read.table(path_to_processed_PDB)
#' Fiscore_secondary(pdb_df)
Fiscore_secondary<-function(pdb_df){

  #to avoid namespace conflucts
  df_resno_val<-pdb_df$"df_resno"
  Fi_score_val<-pdb_df$"Fi_score"
  Type_val<-pdb_df$"Type"

plot<-ggplot2::ggplot(pdb_df) + ggplot2::geom_bar(ggplot2::aes(x=df_resno_val, y = Fi_score_val, fill=Type_val),  stat = "identity")+ggplot2::scale_x_continuous(expand = c(0,0))+ggplot2::ggtitle(label="Fi-score  value distribution for secondary structures")+ggplot2::xlab(label="Residue number")+ggplot2::ylab(label="Fi-score")

plotly::ggplotly(plot)



}
