% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.FF_either.R
\name{FF}
\alias{FF}
\title{Create any firm-firm (FF) matrix}
\usage{
FF(..., who, ties, id_as_firm_name = NULL, Matrix = NULL, self_ties = FALSE)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{who}{Whether to take into account: (\code{ownership}) co-ownership ; (\code{management}) board interlocks, or \code{both} (recognises minimum unambiguous strings).}

\item{ties}{Type of ties to create. Possible values: \code{binary}; \code{naive}; \code{share} (see Details).}

\item{id_as_firm_name}{Whether to use the ticker as the firm's name. Defaults to \code{TRUE} if all firms' id is neither \code{NULL} nor \code{NA}.}

\item{Matrix}{Whether to use the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}. Defaults to \code{TRUE} when any matrix in the pipeline contains more than 10,000 cells and the package is installed.}

\item{self_ties}{Whether to allow self-ties (a 'loop' in graph theory). Defaults to \code{FALSE}.}
}
\value{
A matrix object of class \code{financial_matrix}(possibly using the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package})
}
\description{
General function to create a firm-firm (FF) matrix
}
\details{
See more specific functions for a detailed overview:

 for board interlocks (\code{who == 'management'}):
 \itemize{
  \item \code{\link{FF.binary.management}}, if \code{ties = 'binary'};
  \item \code{\link{FF.binary.management}}, if \code{ties = 'naive'};
  \item \code{\link{FF.norm.management}}, if \code{ties = 'share'}.
 }

 for co-ownership (\code{who == 'ownership'}):
 \itemize{
  \item \code{\link{FF.binary.ownership}}, if \code{ties = 'binary'};
  \item \code{\link{FF.naive.ownership}}, if \code{ties = 'naive'};
  \item \code{\link{FF.norm.ownership}}, if \code{ties = 'share'}.
 }

for both co-ownership and board interlocks (\code{who == 'both'}):
\itemize{
  \item \code{\link{FF.binary.both}}, if \code{ties = 'binary'};
  \item \code{\link{FF.naive.both}}, if \code{ties = 'naive'};
  \item \code{\link{FF.norm.both}}, if \code{ties = 'share'}.
}
}
\examples{

# Create the normalised FF matrix of Berkshire Hathaway's holdings by boards interlocks
data('firms_BKB')
FF <- FF(firms_BKB, who = 'man', ties = 'share')

}
\seealso{
\link{FF.binary.ownership} \link{FF.binary.management} \link{FF.naive.ownership} \link{FF.naive.management} \link{FF.norm.ownership} \link{FF.norm.management}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
