% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovariateData.R
\docType{class}
\name{CovariateData-class}
\alias{CovariateData-class}
\alias{CovariateData}
\alias{show,CovariateData-method}
\alias{summary,CovariateData-method}
\title{Covariate Data}
\usage{
\S4method{show}{CovariateData}(object)

\S4method{summary}{CovariateData}(object)
}
\arguments{
\item{object}{An object of class `CovariateData`.}
}
\description{
\code{CovariateData} is an S4 class that inherits from \code{\link[Andromeda]{Andromeda}}. It contains
information on covariates, which can be either captured on a per-person basis, or aggregated across
the cohort(s).

By default covariates refer to a specific time period, with for example different covariate IDs for
whether a diagnosis code was observed in the year before and month before index date. However, a
\code{CovariateData} can also be temporal, meaning that next to a covariate ID there is also a time ID,
which identifies the (user specified) time window the covariate was captured.

A \code{CovariateData} object is typically created using \code{\link{getDbCovariateData}}, can only be saved using
\code{\link{saveCovariateData}}, and loaded using \code{\link{loadCovariateData}}.
}
\seealso{
\code{\link{isCovariateData}}, \code{\link{isAggregatedCovariateData}}, \code{\link{isTemporalCovariateData}}
}
