% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_estimation.R
\name{estimkiener11}
\alias{estimkiener11}
\alias{estimkiener5}
\alias{estimkiener7}
\title{Estimation Functions with 5, 7 or 11 Quantiles}
\usage{
estimkiener11(x11, p11, ord = 7, maxk = 10)

estimkiener7(x7, p7, maxk = 10)

estimkiener5(x5, p5, maxk = 10)
}
\arguments{
\item{ord}{integer. Option for probability selection and treatment.}

\item{maxk}{numeric. Maximum allowed value for k (kappa).}

\item{x5, x7, x11}{vector of 5, 7 or 11 quantiles.}

\item{p5, p7, p11}{vector of 5, 7 or 11 probabilities.}
}
\description{
Several functions to estimate the parameters of asymmetric Kiener distributions 
with just 5, 7 or 11 quantiles.
}
\details{
These functions, called by \code{paramkienerX5}, \code{paramkienerX7}, 
\code{\link{paramkienerX}}, use 5, 7 or 11 probabilites and quantiles 
to estimate the parameters of Kiener distributions.   

\code{p5, x5} are obtained with functions \code{fiveprobs(X)} and \code{quantile(p5)}.  

\code{p7, x7} are obtained with functions \code{sevenprobs(X)} and \code{quantile(p7)}.  

\code{p11, x11} are obtained with functions \code{elevenprobs(X)} and \code{quantile(p11)}.

The extraction of the 11 probabilities is controlled with the option \code{ord} 
which can take 12 integer values, \code{ord = 7} being the default. 
Small dataset should consider \code{ord = 5} and 
large dataset can consider \code{ord = 12}: 
\enumerate{
  \item{ \code{c(p1, 0.35, 0.50, 0.65, 1-p1)}}
  \item{ \code{c(p2, 0.35, 0.50, 0.65, 1-p2)}}
  \item{ \code{c(p1, p2, 0.35, 0.50, 0.65, 1-p2, 1-p1)}}
  \item{ \code{c(p1, p2, p3, 0.35, 0.50, 0.65, 1-p3, 1-p2, 1-p1)}}
  \item{ \code{c(p1, 0.25, 0.50, 0.75, 1-p1)}}
  \item{ \code{c(p2, 0.25, 0.50, 0.75, 1-p2)}}
  \item{ \code{c(p1, p2, 0.25, 0.50, 0.75, 1-p2, 1-p1)}}
  \item{ \code{c(p1, p2, p3, 0.25, 0.50, 0.75, 1-p3, 1-p2, 1-p1)}}
  \item{ \code{c(p1, 0.25, 0.35, 0.50, 0.65, 0.75, 1-p1)}}
  \item{ \code{c(p2, 0.25, 0.35, 0.50, 0.65, 0.75, 1-p2)}}
  \item{ \code{c(p1, p2, 0.25, 0.35, 0.50, 0.65, 0.75, 1-p2, 1-p1)}}
  \item{ \code{c(p1, p2, p3, 0.25, 0.35, 0.50, 0.65, 0.75, 1-p3, 1-p2, 1-p1)}}
}
\code{p5 = fiveprobs(X)} corresponds to \code{c(p1, 0.25, 0.50, 0.75, 1-p1)}.

\code{p7 = sevenprobs(X)} corresponds to \code{c(p1, p2, 0.25, 0.50, 0.75, 1-p2, 1-p1)}.

The above probabilities are then transfered to the \code{\link{quantile}} function 
whose parameter \code{type} can change significantly the extracted quantiles. 
Our experience is that \code{type = 6} is appropriate when \code{k > 1.9} and 
\code{type = 5} is appropriate when \code{k < 1.9}. 
Other types \code{type = 8} and \code{type = 9} can be considered as well. 
The other types should be ignored. 
(Note: when \code{k < 1.5}, algorithm \code{algo = "reg"} returns better  
results).

Parameter maxk controls the maximum allowed value for estimated parameter k. 
Reasonnable values are \code{maxk = 10, 15, 20}. Default is \code{maxk = 10} 
to be consistent with \code{\link{regkienerLX}}.
}
\examples{
    

require(timeSeries)

## Choose j in 1:16. Choose ord in 1:12 (7 is default)
j    <- 5
ord  <- 5
DS   <- getDSdata()
p11  <- elevenprobs(DS[[j]])
x11  <- quantile(DS[[j]], probs = p11, na.rm = TRUE, names = TRUE, type = 6) 
round(estimkiener11(x11, p11, ord), 3)

## Compare the results obtained with the 12 different values of ord on stock j
compare <- function(ord, x11, p11) {estimkiener11(x11, p11, ord)}
coefk   <- t(sapply(1:12, compare, x11, p11)) 
rownames(coefk) <- 1:12
mcoefk  <- apply(coefk, 2, mean) # the mean of the 12 results above
roundcoefk(rbind(coefk, mcoefk), 13)


}
\seealso{
\code{\link{elevenprobs}}, \code{\link{paramkienerX}}, \code{\link[stats]{quantile}},
\code{\link{roundcoefk}}.
}

