% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{predict.frm}
\alias{predict.frm}
\title{Predict retention times using a FastRet Model}
\usage{
\method{predict}{frm}(object = train_frm(), df = object$df, adjust = NULL, verbose = 0, ...)
}
\arguments{
\item{object}{An object of class \code{frm} as returned by \code{\link[=train_frm]{train_frm()}}.}

\item{df}{A data.frame with the same columns as the training data.}

\item{adjust}{If \code{object} was adjusted using \code{\link[=adjust_frm]{adjust_frm()}}, it will contain a property \code{object$adj}. If \code{adjust} is TRUE, \code{object$adj} will be used to adjust predictions obtained from \code{object$model}. If FALSE \code{object$adj} will be ignored. If NULL, \code{object$model} will be used, if available.}

\item{verbose}{A logical value indicating whether to print progress messages.}

\item{...}{Not used. Required to match the generic signature of \code{predict()}.}
}
\value{
A numeric vector with the predicted retention times.
}
\description{
Predict retention times for new data using a FastRet Model (FRM).
}
\examples{
frm <- read_rp_lasso_model_rds()
newdata <- head(RP)
yhat <- predict(frm, newdata)
}
\seealso{
\code{\link[=train_frm]{train_frm()}}, \code{\link[=adjust_frm]{adjust_frm()}}
}
\keyword{public}
