% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastKRR-package.R
\docType{package}
\name{FastKRR-package}
\alias{FastKRR-package}
\alias{FastKRR}
\title{Kernel Ridge Regression using the \pkg{RcppArmadillo} Package}
\description{
The \pkg{FastKRR} implements its core computational operations in C++ via \pkg{RcppArmadillo}, enabling faster performance than pure R, improved numerical stability, and parallel execution with OpenMP where available. On systems without OpenMP support, the package automatically falls back to single-threaded execution with no user configuration required. For efficient model selection, it integrates with \pkg{CVST} to provide sequential-testing cross-validation that identifies competitive hyperparameters without exhaustive grid search. The package offers a unified interface for exact kernel ridge regression and three widely used scalable approximations—Nyström, Pivoted Cholesky, and Random Fourier Features—allowing analyses with substantially larger sample sizes than are feasible with exact KRR while retaining strong predictive performance. This combination of a compiled backend and scalable algorithms addresses limitations of packages that rely solely on exact computation, which is often impractical for large n. It also integrates with the \pkg{tidymodels} ecosystem via the \pkg{parsnip} model specification \code{krr_reg}, and the S3 method \code{tunable.krr_reg()} (exposes tunable parameters to \code{dials}/\code{tune}); see their help pages for usage.
}
\section{Directory structure}{

\itemize{
  \item \code{R/}: High-level R functions and user-facing API
  \item \code{src/}: C++ sources (kernel computation, fitting, prediction)
}
This package links against \CRANpkg{Rcpp} and \CRANpkg{RcppArmadillo}
(via LinkingTo). It uses \CRANpkg{CVST}, \CRANpkg{parsnip}, and the
\CRANpkg{tidymodels} ecosystem through their public R APIs.
}

\seealso{
\CRANpkg{CVST}, \CRANpkg{Rcpp}, \CRANpkg{RcppArmadillo}, \CRANpkg{parsnip}, \CRANpkg{tidymodels}
}
\author{
\strong{Maintainer}: Kwan-Young Bak \email{kybak@sungshin.ac.kr} (\href{https://orcid.org/0000-0002-4541-160X}{ORCID}) (Sungshin Women's University) [copyright holder]

Authors:
\itemize{
  \item Gyeongmin Kim \email{rlarudals0824@gmail.com} (Sungshin Women's University)
  \item Seyoung Lee \email{sudang0404@gmail.com} (Sungshin Women's University)
  \item Miyoung Jang \email{miyoung9072@gmail.com} (Sungshin Women's University)
}

}
\keyword{package}
