% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Alive.R
\name{Alive}
\alias{Alive}
\title{Living status of individual at given age or calendar date}
\usage{
Alive(idref, refA)
}
\arguments{
\item{idref}{vector of IDs.}

\item{refA}{calendar date (decimal date) or age at which survival status of individuals should be determined. 
Dates can differ between individuals, but number of dates must be same as number of individuals.}
}
\value{
\item{alive_kin}{Living status of ego (if id is a vector) or kin (if id is a dataframe)}
}
\description{
Determines living status of individual at given age or calendar date. The living status is requested for ego or kin. 
If the number provided is less than 200, the number is interpreted as age.
}
\examples{
# Load the data
data(dLH,package="Families")
# Select members of generation 1
idego <- dLH$ID[dLH$gen==1]
# Are egos alive at age 18?
alive <- Alive(idref=idego,refA=18)
# Number alive and deceased
tab <-  table (alive)

## Is ego alive at 18th birthday of oldest child?
date <- sapply(idego,function(x) min(Db(IDch(x))+18))
alive <- Alive(idego,refA=date)

}
