% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multistate.R
\name{Multistate}
\alias{Multistate}
\title{Multistate life table}
\usage{
Multistate(rates, mortality = 1)
}
\arguments{
\item{rates}{rates by age and sex and birth rates by age and birth order (or parity)}

\item{mortality}{Indicator variable. Mortality accounted for if mortality=1, else mortality omitted.}
}
\value{
A list of two objects: 
item{S}{the multistate survival function (S) and multistate transition probabilities (P)}
item{mslt}{other measures of the multistate life table: person-years (L); expectation at birth of sojourn times in the various states (e0); expectation at age x of the remaining expected sojourn times in the various states: population-based measures (e.p); expectation at age x of the remaining expected sojourn times in the various states: status-based measures (e.p)}
}
\description{
Computes fertility table by birth order
}
\details{
The multistate life table is computed using the functions MSLT.S and MLST.e from the Biograph package. The two functions are included in the Multistate function as MSLT_S and MSLT_e.
}
\examples{

data(rates,package = "Families")
z=Multistate(rates)

}
\author{
Frans Willekens
}
