#' @title Catch and effort data for South Indian Ocean Jobfish.
#' 
#' @description Catch and effort data for Jobfish (\emph{Pristipomoides filamentosus}) from the South Indian Ocean.
#' 
#' @name JobfishSIO
#' 
#' @docType data
#' 
#' @format A data frame with 13 observations on the following 2 variables.
#'  \describe{
#'    \item{catch}{Catches (kg).} 
#'    \item{effort}{Effort (man-hours).} 
#'  }
#'  
#' @section Topic(s):
#'  \itemize{
#'    \item Population size 
#'    \item Abundance 
#'    \item Depletion methods 
#'    \item Leslie method
#'    \item DeLury method 
#'    \item Catchability
#'  }
#' 
#' @concept Abundance
#' @concept Population Size
#' @concept Leslie
#' @concept DeLury
#' @concept Depletion
#' @concept Catchability
#' 
#' @source From Table 2 of Grandcourt, E.M. 2003. The effect of intensive line fishing on the virgin biomass of a tropical deepwater snapper, the crimson jobfish (\emph{Pristipomoides filamentosus}). Fisheries Bulletin, 101:305-311. \href{https://raw.githubusercontent.com/fishR-Core-Team/FSAdata/main/data-raw/JobfishSIO.csv}{CSV file}
#' 
#' @keywords datasets
#' 
#' @examples
#' data(JobfishSIO)
#' str(JobfishSIO)
#' head(JobfishSIO)
#' 
NULL