% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RuffeSLRH92.R
\docType{data}
\name{RuffeSLRH92}
\alias{RuffeSLRH92}
\title{Biological characteristics of Ruffe captured in the St. Louis River, Lake Superior in 1992.}
\format{A data frame of 738 observations on the following 11 variables:

\describe{
 \item{fish.id}{A unique fish identification number (across all years, most of which are not shown in this file.}
 \item{month}{Month of capture}
 \item{day}{Day of capture.}
 \item{year}{Year of capture.}
 \item{indiv}{A unique fish identification number within the year.}
 \item{location}{Grid location of capture.}
 \item{length}{Total length (mm).}
 \item{weight}{Weight (g).}
 \item{sex}{Sex factor.}
 \item{maturity}{Maturity stage factor.}
 \item{age}{Age (yrs) from scales.}
}}
\source{
personal collection by the United States Geological Survey, Lake Superior Biological Station, Ashland, WI.
}
\description{
Biological characteristics of Ruffe (\emph{Gymnocephalus cernuus}) captured in the St. Louis River, Lake Superior in 1992.
}
\section{Topic(s)}{

 \itemize{
   \item Length frequency
   \item Length-weight
   \item Growth
   \item von Bertalanffy
   \item Maturity
 }
}
\examples{
data(RuffeSLRH92)
str(RuffeSLRH92)
head(RuffeSLRH92)
op <- par(mfrow=c(2,2),pch=19)
hist(RuffeSLRH92$length,main="")
hist(RuffeSLRH92$age,main="")
plot(weight~length,data=RuffeSLRH92)
plot(length~age,data=RuffeSLRH92)
par(op)
xtabs(~age,data=RuffeSLRH92)
xtabs(~sex,data=RuffeSLRH92)
xtabs(~maturity,data=RuffeSLRH92)
}
\concept{
Growth 'von Bertalanffy' 'Length Frequency' 'Length-Weight' Maturity
}
\keyword{datasets}

