% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSA.R
\docType{package}
\name{FSA}
\alias{FSA}
\alias{FSA-package}
\title{Fisheries stock assessment methods and data.}
\description{
Functions to support basic fisheries stock assessment methods.
}
\details{
Functions from this package can be used to perform a variety of basic fisheries stock assessment methods. Detailed descriptions for most functions are available in the Introductory Fisheries Analysis with R book (Ogle 2016) (see \code{fishR("IFAR")}). Vignettes for the boxed examples in the \dQuote{Analysis and Interpretation of Freshwater Fisheries Data} book can be viewed with \code{fishR("AIFFD")}.

Questions, comments, or suggestions should be given on the \href{https://github.com/fishR-Core-Team/FSA/issues/}{GitHub FSA Issues page}.

Packages with related functionality by the same author are
\itemize{
  \item The \href{https://github.com/fishR-Core-Team/FSAdata/}{FSAdata package} contains additional data sets.
  \item The \href{https://github.com/droglenc/FSAsim/}{FSAsim package} simulation routines for various fisheries methods.
  \item The \href{https://github.com/droglenc/FSAWs/}{FSAWs package} contains functions for developing and validating standard weight equations.
}
}
\references{
Ogle, D.H. 2016. \href{https://fishr-core-team.github.io/fishR/pages/books.html#introductory-fisheries-analyses-with-r}{Introductory Fisheries Analyses with R}. Chapman & Hall/CRC, Boca Raton, FL.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://fishr-core-team.github.io/FSA/}
  \item Report bugs at \url{https://github.com/fishR-Core-Team/FSA/issues}
}

}
\author{
\strong{Maintainer}: Derek H. Ogle \email{DerekOgle51@gmail.com} (\href{https://orcid.org/0000-0002-0370-9299}{ORCID})

Authors:
\itemize{
  \item Jason C. Doll \email{jason.doll@fmarion.edu}
  \item A. Powell Wheeler \email{powell.wheeler@gmail.com}
  \item Alexis Dinno \email{alexis.dinno@pdx.edu} (Provided base functionality of dunnTest())
}

}
\keyword{internal}
