context("bootstrap utilities MESSAGES")
source("EXS_bootstrap.R")

test_that("nlsBoot() methods messages",{
  # testing confint()
  expect_error(confint(nlsBoot1,"derek"),"does not exist in")
  expect_error(confint(nlsBoot1,c("B1","derek")),"does not exist in")
  expect_error(confint(nlsBoot1,4),"exceeds number of columns")
  expect_error(confint(nlsBoot1,-4),"exceeds number of columns")
  expect_error(confint(nlsBoot1,c(1,4)),"exceeds number of columns")
  expect_error(confint(nlsBoot1,-c(1,4)),"exceeds number of columns")
  expect_error(confint(nlsBoot1,c(-1,2)),"cannot be both positive and negative")
  expect_error(confint(nlsBoot1,conf.level=0),"must be between 0 and 1")
  expect_error(confint(nlsBoot1,conf.level=1),"must be between 0 and 1")
  # testing htest()
  expect_error(htest(nlsBoot1,"derek"),"does not exist in")
  expect_error(htest(nlsBoot1,c("B1","derek")),"must be of length 1")
  expect_error(htest(nlsBoot1,4),"exceeds number of columns")
  expect_error(htest(nlsBoot1,-4),"must be positive")
  expect_error(htest(nlsBoot1,c(1,4)),"must be of length 1")
  expect_error(htest(nlsBoot1),"must select a parameter")
  # testing predict()
  expect_error(predict(nlsBoot1,1:7,days=2),"is not a function")
  expect_error(predict(nlsBoot1,fnx,derek=2),"unused argument")
  expect_error(predict(nlsBoot1,fnx,days=2,conf.level=0),"must be between 0 and 1")
  expect_error(predict(nlsBoot1,fnx,days=2,conf.level=1),"must be between 0 and 1")
  expect_error(predict(nlsBoot1,fnx,days=2,digits=0),"must be positive")
})

test_that("bootCase() methods messages",{
  # testing confint()
  expect_error(confint(bootCase1,"derek"),"does not exist in")
  expect_error(confint(bootCase1,c("B1","derek")),"does not exist in")
  expect_error(confint(bootCase1,4),"exceeds number of columns")
  expect_error(confint(bootCase1,-4),"exceeds number of columns")
  expect_error(confint(bootCase1,c(1,4)),"exceeds number of columns")
  expect_error(confint(bootCase1,-c(1,4)),"exceeds number of columns")
  expect_error(confint(bootCase1,c(-1,2)),"cannot be both positive and negative")
  expect_error(confint(bootCase1,conf.level=0),"must be between 0 and 1")
  expect_error(confint(bootCase1,conf.level=1),"must be between 0 and 1")
  # testing htest()
  expect_error(htest(bootCase1,"derek"),"does not exist in")
  expect_error(htest(bootCase1,c("B1","derek")),"must be of length 1")
  expect_error(htest(bootCase1,4),"exceeds number of columns")
  expect_error(htest(bootCase1,-4),"must be positive")
  expect_error(htest(bootCase1,c(1,4)),"must be of length 1")
  expect_error(htest(bootCase1),"must select a parameter")
  # testing predict()
  expect_error(predict(bootCase1,1:7,days=2),"is not a function")
  expect_error(predict(bootCase1,fnx,derek=2),"unused argument")
  expect_error(predict(bootCase1,fnx,days=2,conf.level=0),"must be between 0 and 1")
  expect_error(predict(bootCase1,fnx,days=2,conf.level=1),"must be between 0 and 1")
  expect_error(predict(bootCase1,fnx,days=2,digits=0),"must be positive")
})
