% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/plottingfns.R
\name{plot_spatial_or_ST}
\alias{plot_spatial_or_ST}
\alias{plot_spatial_or_ST,STFDF-method}
\alias{plot_spatial_or_ST,SpatialPointsDataFrame-method}
\alias{plot_spatial_or_ST,SpatialPixelsDataFrame-method}
\alias{plot_spatial_or_ST,SpatialPolygonsDataFrame-method}
\title{Plot a Spatial*DataFrame or STFDF object}
\usage{
plot_spatial_or_ST(
  newdata,
  column_names,
  map_layer = NULL,
  subset_time = NULL,
  palette = "Spectral",
  plot_over_world = FALSE,
  ...
)

\S4method{plot_spatial_or_ST}{STFDF}(
  newdata,
  column_names,
  map_layer = NULL,
  subset_time = NULL,
  palette = "Spectral",
  plot_over_world = FALSE,
  ...
)

\S4method{plot_spatial_or_ST}{SpatialPointsDataFrame}(
  newdata,
  column_names,
  map_layer = NULL,
  subset_time = NULL,
  palette = "Spectral",
  plot_over_world = FALSE,
  ...
)

\S4method{plot_spatial_or_ST}{SpatialPixelsDataFrame}(
  newdata,
  column_names,
  map_layer = NULL,
  subset_time = NULL,
  palette = "Spectral",
  plot_over_world = FALSE,
  ...
)

\S4method{plot_spatial_or_ST}{SpatialPolygonsDataFrame}(
  newdata,
  column_names,
  map_layer = NULL,
  subset_time = NULL,
  palette = "Spectral",
  plot_over_world = FALSE,
  ...
)
}
\arguments{
\item{newdata}{an object of class \code{Spatial*DataFrame} or \code{STFDF}}

\item{column_names}{a vector of strings indicating the columns of the data to plot}

\item{map_layer}{(optional) a \code{ggplot} layer or object to add below the plotted layer, often a map}

\item{subset_time}{(optional) a vector of times to be included; applicable only for \code{STFDF} objects}

\item{palette}{the palette supplied to the argument \code{palette} of \code{scale_*_distiller()}. Alternatively, if \code{palette} = "nasa", a vibrant colour palette is created using \code{scale_*_gradientn()}}

\item{plot_over_world}{logical; if \code{TRUE}, \code{coord_map("mollweide")} and \code{\link{draw_world}} are used to plot over the world}

\item{...}{optional arguments passed on to whatever geom is appropriate for the \code{Spatial*DataFrame} or \code{STFDF} object (\code{geom_point}, \code{geom_tile}, \code{geom_raster}, or \code{geom_polygon})}
}
\value{
A list of \code{ggplot} objects corresponding to the provided \code{column_names}. This list can then be supplied to, for example, \code{ggpubr::ggarrange()}.
}
\description{
Takes an object of class \code{Spatial*DataFrame} or \code{STFDF}, and plots requested data columns using \code{ggplot2}
}
\examples{
## See example in the help file for FRK
}
\seealso{
\code{\link{plot}}
}
