% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/SREutils.R
\docType{methods}
\name{coef}
\alias{coef}
\alias{coef,SRE-method}
\alias{coef,}
\alias{SRE-method}
\title{Retrieve estimated regression coefficients}
\usage{
coef(object, ...)

\S4method{coef}{SRE}(object, ...)
}
\arguments{
\item{object}{object of class \code{SRE}}

\item{...}{currently unused}
}
\description{
Takes a an object of class \code{SRE} and returns a numeric vector with the estimated regression coefficients.
}
\examples{
library(sp)
simdata <- SpatialPointsDataFrame(
               coords = matrix(runif(100), 50, 2),
                data = data.frame(z = rnorm(50)))
BAUs <- BAUs_from_points(SpatialPoints(simdata))
BAUs$fs <- 1
S <- SRE(f = z ~ 1 + coords.x1,
         basis = local_basis(plane()),
         BAUs = BAUs,
         data = list(simdata))
est_reg_coeff <- coef(S)
}
\seealso{
\code{\link{SRE}} for more information on how to construct and fit an SRE model.
}
