% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/savedata_options.R
\name{savedata_options}
\alias{savedata_options}
\title{Data saving options.}
\usage{
savedata_options(
  outfolder = NULL,
  out_fmt = "csv",
  outsp_fmt = "shp",
  out_dsn = NULL,
  out_layer = "outdat",
  outfn.pre = NULL,
  outfn.date = FALSE,
  addtitle = TRUE,
  raw_fmt = "csv",
  raw_dsn = NULL,
  overwrite_dsn = FALSE,
  overwrite_layer = TRUE,
  append_layer = FALSE,
  add_layer = TRUE,
  layer.pre = NULL,
  ...
)
}
\arguments{
\item{outfolder}{String. The outfolder to write files to. If NULL, files are
written to working directory, or if gui=TRUE, a window to browse.}

\item{out_fmt}{String. Format for output tables ('csv', 'sqlite', 'gpkg', 'gdb').}

\item{outsp_fmt}{String. Format for output spatial ('shp', sqlite', 'gpkg', 'gdb').}

\item{out_dsn}{String. Data source name for output. If extension is
not included, out_fmt is used. Use full path if outfolder=NULL.}

\item{out_layer}{outlayer.}

\item{outfn.pre}{String. If savedata=TRUE, prefix for output files. If
rawdata=TRUE, prefix for rawdata files (if raw_fmt = 'csv') or raw_dsn (if
raw_fmt != 'csv').}

\item{outfn.date}{Logical. If TRUE, add current date to out_dsn.}

\item{addtitle}{Logical. If TRUE and savedata=TRUE, adds title to outfile.}

\item{raw_fmt}{String. Format for output rawdata tables ('sqlite',
'gpkg', 'csv', 'gdb').}

\item{raw_dsn}{String. Data source name for rawdata output. If extension is
not included, out_fmt is used. Use full path if outfolder=NULL.}

\item{overwrite_dsn}{Logical. If TRUE, overwrites raw_dsn, if exists.}

\item{overwrite_layer}{Logical. If TRUE, overwrites the output. If
rawdata=TRUE, overwrites out_layer in rawdata folder (if raw_fmt = 'csv') or
out_layers in raw_dsn (if raw_fmt != 'csv').}

\item{append_layer}{Logical. If TRUE, and appends data to existing *.csv
files (if *_fmt = 'csv') or *_dsn layers (if *_fmt != 'csv".}

\item{add_layer}{Logical. If TRUE, adds layer to an existing out_dsn 
(if out_fmt != c('csv','shp')).}

\item{layer.pre}{Layer prefix.}

\item{...}{For extendibility.}
}
\value{
A list of user-supplied parameters and parameter values for saving data.
}
\description{
Returns a list of user-supplied parameters and parameter values for saving data.
}
\details{
If no parameters, an empty list is returned.
}
\examples{

savedata_options(outfolder = "path", overwrite_dsn = FALSE)

}
\author{
Grayson W. White
}
\keyword{options}
