% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spGetXY.R
\name{spGetXY}
\alias{spGetXY}
\title{Spatial wrapper - Extracts XY coordinates within a given boundary.}
\usage{
spGetXY(
  bnd,
  bnd_dsn = NULL,
  bnd.filter = NULL,
  states = NULL,
  RS = NULL,
  xy_datsource,
  xy_dsn = NULL,
  xy = "PLOT",
  xy_opts = xy_options(),
  datsource = NULL,
  data_dsn = NULL,
  dbTabs = dbTables(),
  eval = "FIA",
  eval_opts = NULL,
  pjoinid = "CN",
  invtype = "ANNUAL",
  intensity1 = FALSE,
  pvars2keep = NULL,
  bndvars2keep = NULL,
  clipxy = TRUE,
  showsteps = FALSE,
  returnxy = TRUE,
  savedata = FALSE,
  exportsp = FALSE,
  savedata_opts = NULL
)
}
\arguments{
\item{bnd}{sf R object, Area of Interest (AOI) boundary. Can be a spatial sf
object, full pathname to a shapefile, or name of a layer within a database.}

\item{bnd_dsn}{String. Data source name (dsn; e.g., SQLite database or shapefile
pathname) of bnd. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html). Optional if bnd is an R object.}

\item{bnd.filter}{String. Filter to subset bnd spatial layer.}

\item{states}{String. The name of state(s) for tables (e.g., "Vermont",
"Utah").}

\item{RS}{String. Name of FIA research station to restrict states to
('RMRS','SRS','NCRS','NERS','PNWRS'). If NULL, all research stations are
included.}

\item{xy_datsource}{Source of XY data ('datamart', 'sqlite', 'obj', 'csv').}

\item{xy_dsn}{If datsource='sqlite', the file name (data source name) of
the sqlite database (*.db) where XY data reside.}

\item{xy}{sf R object or String. If xy_dsn = 'datamart', name of xy table 
in FIA DataMart. If xy_dsn = 'sqlite', name of xy layer in database. If 
datsource = 'csv', full pathname of xy CSV file(s). If datsource = 'obj', 
name of xy R object. If datsource = 'shp', full pathname of shapefile.}

\item{xy_opts}{List of xy data options for xy (e.g., xy_opts = list(xvar='LON', 
yvar='LAT'). See xy_options() for more options and defaults.}

\item{datsource}{String. Source of FIA data for defining FIA evaluations or 
appending variables ('datamart', 'sqlite', 'obj', 'csv'). If datsource = NULL, 
datsource = xy_datsource. If datsource = 'datamart', data are downloaded
extracted from FIA DataMart (http://apps.fs.usda.gov/fia/datamart/datamart.html). 
If datsource='sqlite', specify database name(s) in data_dsn and table name(s) 
in dbTabs() argument. If datsource = ('obj','csv'), specify *.csv file name in 
dbTabs argument.}

\item{data_dsn}{String. Name of database with plot_layer and/or ppsa_layer.}

\item{dbTabs}{String or R Object. If data_dsn = 'datamart', name of table(s) 
in FIA DataMart. If data_dsn = 'sqlite', name of layer(s) in database. If 
datsource = 'csv', name of CSV file(s). If datsource = 'obj', name of R object.}

\item{eval}{String. Type of evaluation time frame for data extraction 
('FIA', 'custom'). See eval_opts for more further options.}

\item{eval_opts}{List of evaluation options for 'FIA' or 'custom'
evaluations to determine the set of data returned. See help(eval_options)
for a list of options.}

\item{pjoinid}{String. Variable in plt to join to XY data. Not necessary to
be unique. If using most current XY coordinates, use identifier for a plot
(e.g., PLOT_ID).}

\item{invtype}{String. Type of FIA inventory to extract ('PERIODIC',
'ANNUAL').  Only one inventory type (PERIODIC/ANNUAL) at a time.}

\item{intensity1}{Logical. If TRUE, includes only XY coordinates where 
INTENSITY = 1 (FIA base grid).}

\item{pvars2keep}{String vector. One or more variables in plot table to 
append to output.}

\item{bndvars2keep}{String vector. One or more variables in bnd to 
append to output.}

\item{clipxy}{Logical. If TRUE, clips xy data to bnd.}

\item{showsteps}{Logical. If TRUE, display data in device window.}

\item{returnxy}{Logical. If TRUE, returns XY coordinates.}

\item{savedata}{Logical. If TRUE, saves data to outfolder. Note:
includes XY data if returnxy = TRUE.}

\item{exportsp}{Logical. If savedata = TRUE and returnxy = TRUE, 
if TRUE, exports XY data as spatial data.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}
}
\value{
\item{spxy}{ sf. If returnxy=TRUE, spatial xy point data. }
\item{pltids}{ data frame. A table of pltids that are within bnd. }
\item{spxy}{ sf data frame. If returnxy, a simple feature with pltids within bnd. }
\item{bndx}{ sf object. Input bnd. } 
\item{xy.uniqueid}{ String. Unique identifier of plots in xy. } 
\item{states}{ String. Vector of states that intersect bnd. } 
\item{countyfips}{ String. Vector of countyfips values that intersect bnd. } 
\item{stbnd.att}{ String. Name of state attribute used to select plots. }

If savedata=TRUE and returnxy=TRUE, the plt data frame, including XY 
coordinates is saved to outfolder (xyplt).\cr 
If savedata=TRUE and returnxy=FALSE, the plt data frame, without XY 
coordinates is saved to outfolder (pltids).\cr
If savedata=TRUE and returnxy=TRUE and exportsp=TRUE, the spxy sf object is 
exported as shapefile to outfolder.\cr
}
\description{
Wrapper to get FIA plots within the boundary population (area of interest) -
Intersect with state boundary - Get FIA plots for intersected states,
including tree, and spatial - Clip spatial coordinates and other tables to
boundary (spClipPoint)
}
\details{
\bold{datsource}

Plots are extracted from 3 different data sources:\cr 1) CSV - data have
previously been extracted from the FIA database and stored as CSV files.\cr
2) datamart - data are extracted from FIA's publically-available
datamart.\cr 3) sqlite - data have previously been extracted from the FIA
database and stored within a SQLite database.\cr

\bold{Selection parameters}

FIA plots are selected based on the following parameters:\cr \tabular{ll}{
\tab evalid - the FIA evaluation identifier\cr \tab evalCur - the most
current FIA evaluation in database\cr \tab evalEndyr - the FIA evaluation
ending in evalEndyr\cr \tab evalType - the FIA evaluation type ('ALL',
'AREAVOL', 'GRM', 'P2VEG', 'DWM', 'INV', 'REGEN', 'CRWN')\cr \tab measCur -
the most current measurement of each plot in database\cr \tab measEndyr -
the most current measuremtn of each plot in database in or prior to
measEndyr\cr \tab Endyr.filter - a filter for bnd that specifies the
boundary where measEndyr should be applied\cr }
}
\note{
If savebnd=TRUE:\cr If out_fmt=c('csv','shp'), the st_write (sf) function
is called. The ArcGIS driver truncates variable names to 10 characters or
less. Variable names are changed before export using an internal function
(trunc10shp). If Spatial object has more than 1 record, it will be returned
but not exported.

If datsource="datmart", (default), data are imported from FIA DataMart.  The
plot coordinates have been altered for privacy (See
https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php for details).
The zip files are extracted on-the-fly from the online website. Web server
connections will affect download speeds.
}
\examples{
\dontrun{
# Set up data from FIESTA
WYbhfn <- system.file("extdata",
                      "sp_data/WYbighorn_adminbnd.shp",
                      package = "FIESTA")
# Use spGetXY
WYbhxy <- spGetXY(bnd = WYbhfn,
                  xy_datsource = "datamart",
                  eval = "custom",
                  eval_opts = list(Cur = TRUE),
                  returnxy = TRUE)
}
}
\author{
Tracey S. Frescino
}
\keyword{data}
