% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datBarStacked.R
\name{datBarStacked}
\alias{datBarStacked}
\title{Data - Generates frequency barplot.}
\usage{
datBarStacked(
  x,
  main.attribute,
  sub.attribute,
  response = "phat",
  percent = FALSE,
  LUT.color = NULL,
  color = "rainbow",
  device.type = "default",
  jpeg.res = 300,
  device.width = 9,
  device.height = 6,
  mar = NULL,
  horiz = TRUE,
  bar.lim = NULL,
  bar.ratio = 1,
  ylabel = NULL,
  xlabel = NULL,
  las.xnames = NULL,
  main.order = NULL,
  sub.order = NULL,
  legend.fit = NULL,
  legend.cex = 0.8,
  legend.x = NULL,
  legend.y = NULL,
  legend.title = NULL,
  legend.bty = "o",
  legend.bg = par("bg"),
  legend.inset = 0,
  legend.xpd = par("xpd"),
  main = NULL,
  cex.main = 1,
  cex.label = 1,
  cex.names = 0.8,
  sub.add0 = FALSE,
  savedata = FALSE,
  outfolder = NULL,
  outfn = NULL,
  outfn.pre = NULL,
  outfn.date = TRUE,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{x}{Data frame or comma-delimited file (*.csv) - table of values to be
plotted.}

\item{main.attribute}{String. The column to be used for each bar.}

\item{sub.attribute}{String. The column to be used to subdivide each bar.}

\item{response}{String. The column of values to be plotted. Currently
defaults to "phat".}

\item{percent}{Logical. If TRUE, values cover values in a stack are
converted to percent of stack.}

\item{LUT.color}{Data frame or comma-delimited file (*.csv) - look up table
for colors.  Must contain column with same name as sub.attribute.}

\item{color}{String. Automated color selection ("rainbow", "topo", "heat",
"terrain", "cm").}

\item{device.type}{String. The type(s) of device for ploting ("default",
"jpg", "pdf", or "ps").}

\item{jpeg.res}{Integer. The resolution for jpeg image.}

\item{device.width}{Integer. The width of output device (in inches)'}

\item{device.height}{Integer. The height of output device (in inches)'}

\item{mar}{See par.. A numerical vector representing number of lines for
margins (c(bottom, left, top, right).}

\item{horiz}{Logical. See barplot. If FALSE, the bars are drawn vertically
with the first bar to the left. If TRUE, the bars are drawn horizontally
with the first bar at the bottom.}

\item{bar.lim}{Number vector. Equivalent to xlim or ylim, for whichever is
the lengthwise axis in barcharts (ex. c(0,10)). Warning: for lower limits
other than zero (ex. c(20,100), will behave strangely because par(xpd) is
set to NA.}

\item{bar.ratio}{Proportion of figure area taken up by barplot vs taken by
legend.}

\item{ylabel}{String. A label for the y axis (same as ylab).}

\item{xlabel}{String. A label for the x axis (same as xlab).}

\item{las.xnames}{Number. The direction of x variable names (0,1,2,3).
0:Default, parallel; 1:horizontal; 2:perpendicular; 3:vertical.}

\item{main.order}{String vector. A vector of main.attribute names in desired
order for bars. May also be 'DESC' or 'ASC'.}

\item{sub.order}{String vector. Avector of sub.attribute names in desired
order for stack, with the first name used as the column in each stack. If
NULL, the order is based on the overall cover of each sub.attribute. May
also be 'DESC' or 'ASC'.}

\item{legend.fit}{Logical. Should bar.lim be changed to fit the legend of
the plot.  Will only be used if the legend is on the right side of a
horizontal plot or the top of a vertical plot. (i.e. horiz=FALSE).}

\item{legend.cex}{Number. Expansion factor for legend text.}

\item{legend.x}{See legend. The x coordinate to be used to position the
legend. If horiz=TRUE, suggested options include "topright" or
"bottomright". If horiz=FALSE, suggested options include "topleft" or
"topright".}

\item{legend.y}{See legend. The y coordinate to be used to position the
legend.}

\item{legend.title}{See legend. A title for the legend.}

\item{legend.bty}{See legend. the type of box to be drawn around the legend.}

\item{legend.bg}{See legend. The background color for the legend box.}

\item{legend.inset}{See legend. The distance from the margins as a fraction
of the plot region.}

\item{legend.xpd}{See legend.}

\item{main}{String. Title for plot.}

\item{cex.main}{Number. Expansion factor for title.}

\item{cex.label}{Number. A number representing cex in barplot (size
expansion of x and/or ylabels.}

\item{cex.names}{Number. Expansion factor for axis names (bar labels). Ex.
0.5 represents half the size.}

\item{sub.add0}{Logical. If TRUE, adds categories with 0 values to
sub.attribute legend.}

\item{savedata}{Logical. If TRUE, writes output data to outfolder (jpg and
pdf).}

\item{outfolder}{String. The name of the output folder. If savedata=TRUE,
all output saved to the outfolder. If savedata=FALSE, only a text file of
input parameters is saved.}

\item{outfn}{String. The name of the output file if savedata=TRUE (*.csv).
Do not include extension. If NULL, the file will be named
BARPLOT_'yvar_date'.csv}

\item{outfn.pre}{String. Add a prefix to output name (e.g., "01").}

\item{outfn.date}{Logical. If TRUE, add date to end of outfile (e.g.,
outfn_'date'.csv).}

\item{overwrite}{Logical. If TRUE and exportshp=TRUE, overwrite files in
outfolder.}

\item{...}{list of additional arguments to pass to barplot(); names of the
list are used as argument names.}
}
\value{
Outputs stacked barplot to display window.
}
\description{
Generate a barplot of frequencies in order from most to least.
}
\details{
# Note: This function uses a customized lengthwise axis (y axis if horiz=F,
x axis if horiz=T) # Therefore to modify this axis by par commands (other
than the # ones specifically included above) may require changing the
function. For example par(yaxp) # may not work.  # # # The arguments bar.lab
and bar.lim are equivalent to xlab/ylab, xlim/ylim, controlling # whichever
is the lengthwise axis in the bar charts (as detrmined by horiz).  # # #
bar.ratio is only used when bar.lim is specified, it controls what
percentage of the # plot area will be occupied by the specified range of the
chart itself. For example, setting # bar.lim=c(0,80) and bar.ratio=0.75 will
result in the 80% tick mark occuring 75% of the way # across the plot
region, leaving 25% of the plot region for the legend. (Note, if any of #
the bars are taller than 80% they will still overlap the legend.)  # # If
bar.lim is not specified, the function will automatically scale the
lengthwise axis so # that all the bars are as tall as possible, but none of
the bars over lap the legend.  # # The main purpose of specifying bar.lim is
if you want multiple forest types to be shown at # the same scale,
sacrificing individual forest type details to make the graphs comparable #
across forest types. Then you may need to fiddle with bar.ratio till the
plots all look good.
}
\note{
If savedata = TRUE, writes a jpg and pdf of barplot to outfolder.
}
\author{
Elizabeth Freeman, Tracey S. Frescino
}
\keyword{data}
