% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.FGLMtrunc.R
\name{predict.FGLMtrunc}
\alias{predict.FGLMtrunc}
\title{Make predictions from \code{FGLMtrunc} fitted model}
\usage{
\method{predict}{FGLMtrunc}(
  object,
  newX.curves,
  newS = NULL,
  type = c("link", "response", "coefficients"),
  ...
)
}
\arguments{
\item{object}{fitted \code{FGLMtrunc} object}

\item{newX.curves}{Matrix of new values for functional predictors \code{X.curves}.}

\item{newS}{Matrix of new values for scalar predictors \code{S}.}

\item{type}{Type of prediction. For logistic regression (\code{family = "binomial"}), \code{type="link"} gives the linear
predictors, which is log-odds, and \code{type="response"} gives the predicted probabilities.
For linear regression (\code{family = "gaussian"}), both \code{type="link"} and  \code{type="response"} give fitted values.
For both linear regression and logistic regression, \code{type="coefficients"} gives truncated estimate of functional parameter \eqn{\beta}.}

\item{\dots}{additional predict arguments (Not applicable for FGLMtrunc)}
}
\value{
Predictions depends on chosen \code{type}.
}
\description{
This function returns truncated estimate of linear predictors, fitted values, and functional parameter \eqn{\beta}
for a fitted \code{FGLMtrunc} object.
}
\seealso{
\link[stats]{predict.glm}.
}
