% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power.tcorr}
\alias{power.tcorr}
\title{Compute power of the t-test for non-zero correlation}
\usage{
power.tcorr(n, alpha, rho)
}
\arguments{
\item{n}{sample size (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{rho}{population correlation coefficient (vector)}
}
\value{
Vector of power estimates for two-sided tests
}
\description{
Compute power of the t-test for non-zero correlation
}
\details{
For many applications, the null.effect is rho = 0
}
\examples{
rho = rep(c(0.3,0),c(100,900));
res = power.tcorr(n = 50, alpha = 0.05, rho = rho)
}
