% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{n.fdr.twoprop}
\alias{n.fdr.twoprop}
\title{Sample size calculation for comparing two proportions}
\usage{
n.fdr.twoprop(fdr, pwr, p1, p2, alternative = "two.sided", pi0.hat = "BH")
}
\arguments{
\item{fdr}{desired FDR (scalar numeric)}

\item{pwr}{desired average power (scalar numeric)}

\item{p1}{probability in one group (vector)}

\item{p2}{probability in other group (vector)}

\item{alternative}{one- or two-sided test}

\item{pi0.hat}{approximation method for null proportion}
}
\value{
A list with the following components:
\item{n}{a sample size estimate}
\item{computed.avepow}{average power}
\item{desired.avepow}{desired average power}
\item{desired.fdr}{desired FDR}
\item{input.pi0}{proportion of tests with a true null hypothesis}
\item{alpha}{fixed p-value threshold for multiple testing procedure}
\item{n.its}{number of iteration}
\item{max.its}{maximum number of iteration, default is 50}
\item{n0}{lower limit for initial sample size range}
\item{n1}{upper limit for initial sample size range}
}
\description{
Find the sample size needed to have a desired false discovery rate and average power for a large number of two-group comparisons using the two proportion z-test.
}
\examples{
set.seed(1234);
p1 = sample(seq(0,0.5,0.1),40,replace = TRUE);
p2 = sample(seq(0.5,1,0.1),40,replace = TRUE);
n.fdr.twoprop(fdr = 0.1, pwr = 0.8, p1 = p1, p2 = p2, alternative = "two.sided", pi0.hat = "BH")
}
