% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arguments.R
\name{gen.params.gmjmcmc}
\alias{gen.params.gmjmcmc}
\title{Generate a parameter list for GMJMCMC (Genetically Modified MJMCMC)}
\usage{
gen.params.gmjmcmc(data)
}
\arguments{
\item{data}{A data frame containing the dataset with covariates and response variable.}
}
\value{
A list of parameters for controlling GMJMCMC behavior:
}
\description{
This function generates the full list of parameters required for the Generalized Mode Jumping Markov Chain Monte Carlo (GMJMCMC) algorithm, building upon the parameters from \code{gen.params.mjmcmc}. The generated parameter list includes feature generation settings, population control parameters, and optimization controls for the search process.
}
\section{Feature Generation Parameters (\code{feat})}{

\describe{
\item{\code{feat$D}}{Maximum feature depth, default \code{5}. Limits the number of recursive feature transformations. For fractional polynomials, it is recommended to set \code{D = 1}.}
\item{\code{feat$L}}{Maximum number of features per model, default \code{15}. Increase for complex models.}
\item{\code{feat$alpha}}{Strategy for generating $alpha$ parameters in non-linear projections:
\describe{
\item{\code{"unit"}}{(Default) Sets all components to 1.}
\item{\code{"deep"}}{Optimizes $alpha$ across all feature layers.}
\item{\code{"random"}}{Samples $alpha$ from the prior for a fully Bayesian approach.}
}}
\item{\code{feat$pop.max}}{Maximum feature population size per iteration. Defaults to \code{min(100, as.integer(1.5 * p))}, where \code{p} is the number of covariates.}
\item{\code{feat$keep.org}}{Logical flag; if \code{TRUE}, original covariates remain in every population (default \code{FALSE}).}
\item{\code{feat$prel.filter}}{Threshold for pre-filtering covariates before the first population generation. Default \code{0} disables filtering.}
\item{\code{feat$prel.select}}{Indices of covariates to include initially. Default \code{NULL} includes all.}
\item{\code{feat$keep.min}}{Minimum proportion of features to retain during population updates. Default \code{0.8}.}
\item{\code{feat$eps}}{Threshold for feature inclusion probability during generation. Default \code{0.05}.}
\item{\code{feat$check.col}}{Logical; if \code{TRUE} (default), checks for collinearity during feature generation.}
\item{\code{feat$max.proj.size}}{Maximum number of existing features used to construct a new one. Default \code{15}.}
}
}

\section{Scaling Option}{

\describe{
\item{\code{rescale.large}}{Logical flag for rescaling large data values for numerical stability. Default \code{FALSE}.}
}
}

\section{MJMCMC Parameters}{

\describe{
\item{\code{burn_in}}{The burn-in period for the MJMCMC algorithm, which is set to 100 iterations by default.}

\item{\code{mh}}{A list containing parameters for the regular Metropolis-Hastings (MH) kernel:
\describe{
\item{\code{neigh.size}}{The size of the neighborhood for MH proposals with fixed proposal size, default set to 1.}
\item{\code{neigh.min}}{The minimum neighborhood size for random proposal size, default set to 1.}
\item{\code{neigh.max}}{The maximum neighborhood size for random proposal size, default set to 2.}
}
}

\item{\code{large}}{A list containing parameters for the large jump kernel:
\describe{
\item{\code{neigh.size}}{The size of the neighborhood for large jump proposals with fixed neighborhood size, default set to the smaller of \code{0.35 * p} and \code{35}, where \eqn{p} is the number of covariates.}
\item{\code{neigh.min}}{The minimum neighborhood size for large jumps with random size of the neighborhood, default set to the smaller of \code{0.25 * p} and \code{25}.}
\item{\code{neigh.max}}{The maximum neighborhood size for large jumps with random size of the neighborhood, default set to the smaller of \code{0.45 * p} and \code{45}.}
}
}

\item{\code{random}}{A list containing a parameter for the randomization kernel:
\describe{
\item{\code{prob}}{The small probability of changing the component around the mode, default set to 0.01.}
}
}

\item{\code{sa}}{A list containing parameters for the simulated annealing kernel:
\describe{
\item{\code{probs}}{A numeric vector of length 6 specifying the probabilities for different types of proposals in the simulated annealing algorithm.}
\item{\code{neigh.size}}{The size of the neighborhood for the simulated annealing proposals, default set to 1.}
\item{\code{neigh.min}}{The minimum neighborhood size, default set to 1.}
\item{\code{neigh.max}}{The maximum neighborhood size, default set to 2.}
\item{\code{t.init}}{The initial temperature for simulated annealing, default set to 10.}
\item{\code{t.min}}{The minimum temperature for simulated annealing, default set to 0.0001.}
\item{\code{dt}}{The temperature decrement factor, default set to 3.}
\item{\code{M}}{The number of iterations in the simulated annealing process, default set to 12.}
}
}

\item{\code{greedy}}{A list containing parameters for the greedy algorithm:
\describe{
\item{\code{probs}}{A numeric vector of length 6 specifying the probabilities for different types of proposals in the greedy algorithm.}
\item{\code{neigh.size}}{The size of the neighborhood for greedy algorithm proposals, set to 1.}
\item{\code{neigh.min}}{The minimum neighborhood size for greedy proposals, set to 1.}
\item{\code{neigh.max}}{The maximum neighborhood size for greedy proposals, set to 2.}
\item{\code{steps}}{The number of steps for the greedy algorithm, set to 20.}
\item{\code{tries}}{The number of tries for the greedy algorithm, set to 3.}
}
}

\item{\code{loglik}}{A list to store log-likelihood values, which is by default empty.}
}
}

\examples{
data <- data.frame(y = rnorm(100), x1 = rnorm(100), x2 = rnorm(100))
params <- gen.params.gmjmcmc(data)
str(params)

}
\seealso{
\code{\link{gen.params.mjmcmc}}, \code{\link{gmjmcmc}}
}
