% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faostat_bulk_download.R
\name{read_faostat_bulk}
\alias{read_faostat_bulk}
\title{Function to read zipped files and return a data frame
Reads the main csv file within the archive.
The main file has the same name as the name of the archive. 
Note: the zip archive might also contain metadata files about Flags and Symboles.}
\usage{
read_faostat_bulk(zip_file_name)
}
\arguments{
\item{zip_file_name}{character name of the zip file to read}
}
\value{
data frame of FAOSTAT data
}
\description{
Function to read zipped files and return a data frame
Reads the main csv file within the archive.
The main file has the same name as the name of the archive. 
Note: the zip archive might also contain metadata files about Flags and Symboles.
}
\examples{
\dontrun{
# Read a file then assign it to a data frame and save it as rds
forestry_e_all_data <- read_faostat_bulk("data_raw/Forestry_E_All_Data_(Normalized).zip")
saveRDS(forestry_e_all_data,"data_raw/forestry_e_all_data.rds")
}
}
