% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_functions.R
\name{plot_json_graph}
\alias{plot_json_graph}
\title{Plot an igraph visualization of a JSON document}
\usage{
plot_json_graph(
  .x,
  legend = TRUE,
  vertex.size = 6,
  edge.color = "grey70",
  edge.width = 0.5,
  show.labels = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{.x}{a JSON string or tbl_json object}

\item{legend}{add a type color legend automatically}

\item{vertex.size}{the size of the vertices}

\item{edge.color}{the color for the edges}

\item{edge.width}{the width of the edge lines}

\item{show.labels}{should object names be shown}

\item{plot}{should the plot be rendered?}

\item{...}{further arguments to igraph::plot.igraph}
}
\value{
Graph visualization of a json-ld
}
\description{
Plot an igraph visualization of a JSON document
}
\examples{
json_file <- '{
"@context": "http://schema.org/",
"@type": "Person",
"name": "Jane Doe",
"jobTitle": "Professor",
"telephone": "(425) 123-4567",
"url": "http://www.janedoe.com"}'

plot_json_graph(json_file)
}
