% Generated by roxygen2 (4.0.2): do not edit by hand
\name{JohnsonSB}
\alias{JohnsonSB}
\alias{dJohnsonSB}
\alias{eJohnsonSB}
\alias{lJohnsonSB}
\alias{pJohnsonSB}
\alias{qJohnsonSB}
\alias{rJohnsonSB}
\title{The Johnson SB Distribution.}
\usage{
dJohnsonSB(x, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2))

pJohnsonSB(q, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2))

qJohnsonSB(p, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2))

rJohnsonSB(n, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2))

eJohnsonSB(X, w, method = "numerical.MLE")

lJohnsonSB(X, w, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2),
  logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{gamma,delta}{shape parameters.}

\item{xi,lambda}{location-scale parameters.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lJohnsonSB gives log likelihood.}

\item{...}{other parameters}
}
\value{
dJohnsonSB gives the density; pJohnsonSB gives the distribution function;
qJohnsonSB gives the quantile function; rJohnsonSB generates random variables;
eJohnsonSB estimate the parameters
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the 4 Parameter beta distribution
}
\details{
Johnson SB Distribution

Johnson SB is bounded in [xi,xi+lambda].
See \href{../doc/Distributions-Johnson-SB.html}{Distributions-Johnson-SB}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
gamma = -0.5; delta = 2; xi = -0.5; lambda = 2
X <- rJohnsonSB(n, gamma, delta, xi, lambda)
(est.par <- eJohnsonSB(X))
# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dJohnsonSB(den.x,params = est.par)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qJohnsonSB((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(a,b), ylim = c(a,b))
abline(0,1)

plot((1:n-0.5)/n, pJohnsonSB(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2)
X <- rJohnsonSB(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eJohnsonSB(X,w) # estimated parameters of weighted sample
eJohnsonSB(X) # estimated parameters of unweighted sample

# Extracting location, scale and shape parameters
est.par[attributes(est.par)$par.type=="location"]
est.par[attributes(est.par)$par.type=="scale"]
est.par[attributes(est.par)$par.type=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rJohnsonSB,edist=eJohnsonSB,n = 1000, rep.num = 1e3,
params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2), method ="numerical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rJohnsonSB(1000, gamma, delta, xi, lambda)
(est.par <- eJohnsonSB(X))
H <- attributes(eJohnsonSB(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lJohnsonSB(X,param = est.par)
lJohnsonSB(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

