% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_mmax.R
\name{recombination_mmax}
\alias{recombination_mmax}
\title{Min Max Arithmetical recombination for DE}
\usage{
recombination_mmax(X, M, recpars = list(lambda = NULL))
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/mmax" (min-max-arithmetical) recombination for the ExpDE 
framework
}
\section{Warning}{

This recombination operator evaluates \code{4*popsize} candidate solutions 
per iteration of the algorithm. The value of the \code{nfe} counter and the 
vector of performance values \code{G} are updated in the calling environment.
}

\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_pbest()} understands the following 
fields in \code{recpars}:
\itemize{
   \item \code{lambda} : Recombination multiplier.\cr
                         Optional. Defaults to \code{NULL}
                         Accepts numeric value \code{0 < lambda < 1} or 
                         \code{NULL} (in which case a random value is 
                         independently used for each variable of each 
                         recombination pair).
}
}

\section{References}{

F. Herrera, M. Lozano, A. M. Sanchez, "A taxonomy for the crossover
operator for real-coded genetic algorithms: an experimental study", 
International Journal of Intelligent Systems 18(3):309-338, 2003.\cr
F Herrera, M. Lozano,  J.L. Verdegay, "Tuning fuzzy logic controllers by 
genetic algorithms.", International Journal of Approximate Reasoning 
12(3):299-315, 1995. \cr
}

