% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AjustarRegressao.R
\name{AjustarRegressao}
\alias{AjustarRegressao}
\title{Ajuste de modelos de regressao multipla}
\usage{
AjustarRegressao(Dados,design,verbose=TRUE)
}
\arguments{
\item{Dados}{Matriz contendo 3 colunas obrigatoriamente caso o design seja
1 (experimento sem repeticoes), sendo as duas primeiras as variaveis
explicativas e a terceira a variavel resposta. Se houver repeticoes (Design
2 ou 3) a matriz deve conter obrigatoriamente 4 colunas, as duas primeiras
com as variaveis explicativas, a terceira com a identificacao das
repeticoes/blocos e a quarta coluna com a variavel resposta.}

\item{design}{Indica o delineamento utilizado na pesquisa:
\itemize{
\item design 1 -> Experimento  sem repeticao.
\item design 2 -> Experimento no delineamento inteiramente casualizado (Dic).
\item design 3 -> Experimento no delineamento em blocos casualizados (Dbc).
  }}

\item{verbose}{Valor logico (TRUE ou FALSE) indicando se os resultados devem
ou nao serem apresentados no console.}
}
\value{
A funcao retorna o resultado do ajuste de 12 modelos de regressao.
Estes resultados podem ser apresentados no console, e alem disso, estao
carregados em um objeto do tipo list.
}
\description{
Esta funcao realiza o ajuste de 12 modelos de regressao multipla
  considerando 2 variaveis independentes (explicativas) e uma variavel
  dependente (resposta). E possivel analisar dados de experimentos avaliados
  sem delineamento (repeticoes) e com delineamento estatistico (DIC e DBC)
}
\examples{
#Exemplo 1: Experimento sem delineamento
data("Dados1")
res=AjustarRegressao(Dados = Dados1, design=1,verbose=FALSE)
plot2D(res,niveis = 3)
plot2D(res,niveis = 3,xlab="Comprimento (cm)",ylab="Largura (cm)",
       Metodo = "simple")
plot2D(res,niveis = 5,xlab="Comprimento (cm)",ylab="Largura (cm)",
       Metodo="edge",col.contour = "blue")
plot3D(res)

##########################
#Criando paleta de cores
col0 = colorRampPalette(c('white', 'cyan', '#007FFF', 'blue','#00007F'))
col1 = colorRampPalette(c('#7F0000', 'red', '#FF7F00', 'yellow', 'white',
                         'cyan', '#007FFF', 'blue','#00007F'))
col2 = colorRampPalette(c('#67001F', '#B2182B', '#D6604D', '#F4A582',
                         '#FDDBC7', '#FFFFFF', '#D1E5F0', '#92C5DE',
                         '#4393C3', '#2166AC', '#053061'))
col3 = colorRampPalette(c('red', 'white', 'blue'))
col4 = colorRampPalette(c('#7F0000', 'red', '#FF7F00', 'yellow', '#7FFF7F',
                         'cyan', '#007FFF', 'blue', '#00007F'))

plot2D(res,niveis = 5,xlab="Comprimento (cm)",ylab="Largura (cm)",
      Metodo="edge",contour = TRUE,cor=col0(200),box=FALSE)


plot2D(res,niveis = 10,xlab="Comprimento (cm)",ylab="Largura (cm)",zlab=FALSE,
      contour = TRUE,cor=col1(200),box=TRUE,col.contour = "black",
      main="Superficie Resposta")


##############################################################################
##############################################################################
#Exemplo 2: Experimento sem delineamento
data("Dados2")
res=AjustarRegressao(Dados = Dados2, design=1,verbose=TRUE)
plot2D(res,niveis = 10,xlab="Acucar (\%)",ylab="Banana (\%)",
zlab="Aceitabilidade",
      contour = TRUE,cor=col1(200),box=TRUE,col.contour = "black",
      main="Superficie Resposta")
plot3D(res)

##############################################################################
##############################################################################
#Exemplo 3: Experimento com delineamento (DIC)
data("Dados3")
res=AjustarRegressao(Dados = Dados3, design=2,verbose=TRUE)
plot2D(res,niveis = 5, Metodo="edge",contour = FALSE)
plot2D(res,niveis = 5, Metodo="edge",contour = TRUE,col.contour = "black")

##############################################################################
##############################################################################
#Exemplo 4: Experimento com delineamento (DBC)
data("Dados3")
res=AjustarRegressao(Dados = Dados3, design=3,verbose=TRUE)
plot2D(res,niveis = 20,xlab="N (K/ha)",ylab="K (Kg/ha)",
      Metodo="edge",contour = TRUE,cor=col1(200),box=TRUE)
plot2D(res,niveis = 5, Metodo="edge",contour = TRUE,col.contour = "black")
plot3D(res)

}
\references{
Tutoriais onlines:
https://www.youtube.com/playlist?list=PLvth1ZcREyK6OUnWVs-hnyVdCB1xuxbVs
}
\seealso{
\code{\link{plot2D}}, \code{\link{plot3D}}, \code{\link{predict3D}}
}
