% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_trend_graph.R
\name{prepare_trend_graph}
\alias{prepare_trend_graph}
\title{Prepares a Trend Graph}
\usage{
prepare_trend_graph(
  df,
  ts_id,
  var = colnames(df[sapply(df, is.numeric) & colnames(df) != ts_id])
)
}
\arguments{
\item{df}{Data frame containing the ordered factor and a set of numerical variables
to be plotted}

\item{ts_id}{a string containing the column name of the ordered factor
(normally the time-series indicator)}

\item{var}{a character vector containing the column names of the variables
that should be plotted. Defaults to all numeric variables of the data frame
besides the one indicated by \code{ts_id}.}
}
\value{
A list containing two items:
\describe{
 \item{"df"}{A data frame containing the plotted means and standard errors}
 \item{"plot}{The plot as returned by \code{ggplot}}
}
}
\description{
Reads a data frame and line plots all variables (which need to be numeric)
 by an ordered factor (normally the time-series indicator).
}
\examples{
df <- data.frame(year = floor(time(EuStockMarkets)), EuStockMarkets)
graph <- prepare_trend_graph(df, "year")
graph$plot
}
