% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ethseq_RM.R
\name{ethseq.RM}
\alias{ethseq.RM}
\title{Create a reference model for ethnicity analysis}
\usage{
ethseq.RM(vcf.fn, annotations, out.dir = "./",
  model.name = "Reference.Model", bed.fn = NA, phased = FALSE,
  call.rate = 1, cores = 1)
}
\arguments{
\item{vcf.fn}{Paths to genotype files in VCF format}

\item{annotations}{data.frame associating all sample names to corresponding ethnicities and genders}

\item{out.dir}{Path to output folder}

\item{model.name}{Name of the output model}

\item{bed.fn}{Path to BED file with regions of interest}

\item{phased}{Logical value indicating if the genotypes are phased}

\item{call.rate}{SNPs call rate cutoff for inclusion in the final reference model}

\item{cores}{Number of cores to use in the reference model generation}
}
\value{
Logical value indicating the success of the analysis
}
\description{
This function creates a GDS reference model that can be used to performe EthSEQ ethnicity analysis
}
\examples{
### Load list of VCF files paths
vcf.files = 
  c(system.file("extdata", "VCF_Test_1.vcf", package="EthSEQ"),
    system.file("extdata", "VCF_Test_2.vcf", package="EthSEQ"))

### Load samples annotations
annot.samples = read.delim(system.file("extdata", "Annotations_Test.txt",
	package="EthSEQ"))

out.dir = tempdir()
dir.create(out.dir)

### Create reference model
ethseq.RM(
  vcf.fn = vcf.files,
  annotations = annot.samples,
  out.dir = out.dir,
  model.name = "Reference.Model",
  bed.fn = NA,
  phased = FALSE,
  call.rate = 1,
  cores = 1)

unlink(out.dir,recursive=TRUE)

}

