% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp.options.R
\encoding{UTF-8}
\name{interp.options}
\alias{interp.options}
\title{Configure various aspects of interpolating function in \code{TTT_hazard_shape}}
\usage{
interp.options(interp.fun = "splinefun", length.out = 10, ...)
}
\arguments{
\item{interp.fun}{character. This argument defines the interpolating
function used. Default value is \code{"splinefun"}. Visit the
\strong{Details} section for further information.}

\item{length.out}{numeric. Number of points interpolated. Default value is 10.}

\item{...}{further arguments passed to the interpolating function.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

This function allows the user to set the parameters of any of the following
interpolating functions which can be used inside \code{\link{TTT_hazard_shape}}.
}
\details{
Each interpolating function has its particular arguments. The following
interpolating functions are  recommended:

\itemize{
\item \code{\link[stats]{approxfun}}
\item \code{\link[stats]{splinefun}}
\item \code{\link{spline}}
}

The user can also implement a custom interpolating function.
}
\seealso{
\code{\link[stats]{approxfun}}, \code{\link[stats]{splinefun}},
\code{\link[stats]{smooth}}, \code{\link[stats]{smooth.spline}},
\code{\link[stats]{loess}}, \code{\link{TTT_hazard_shape}}
}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
